"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styles = exports.PageHeader = exports.ExperimentalBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _link_icon = require("./link_icon");
var i18n = _interopRequireWildcard(require("../translations"));
var _truncated_text = require("./truncated_text");
var _use_navigation = require("../../../hooks/use_navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const styles = {
  linkBack: (0, _react2.css)`
    font-size: ${_uiTheme.euiThemeVars.euiFontSizeXS};
    line-height: ${_uiTheme.euiThemeVars.euiLineHeight};
    margin-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
  `
};
exports.styles = styles;
const ExperimentalBadge = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.EXPERIMENTAL_LABEL,
  tooltipContent: i18n.EXPERIMENTAL_DESCRIPTION,
  tooltipPosition: "bottom"
}));
exports.ExperimentalBadge = ExperimentalBadge;
ExperimentalBadge.displayName = 'ExperimentalBadge';
const Title = /*#__PURE__*/_react.default.memo(({
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "baseline",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
    text: title
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ExperimentalBadge, null)))), description ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "description"
  }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
    text: description
  }))) : null);
});
Title.displayName = 'Title';
const PageHeader = /*#__PURE__*/_react.default.memo(({
  showBackButton = false,
  title,
  description
}) => {
  const {
    navigateToMaintenanceWindows
  } = (0, _use_navigation.useMaintenanceWindowsNavigation)();
  const navigateToMaintenanceWindowsClick = (0, _react.useCallback)(() => {
    navigateToMaintenanceWindows();
  }, [navigateToMaintenanceWindows]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showBackButton && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "link-back",
    css: styles.linkBack
  }, /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    onClick: navigateToMaintenanceWindowsClick,
    iconType: "arrowLeft"
  }, i18n.MAINTENANCE_WINDOWS_RETURN_LINK)), /*#__PURE__*/_react.default.createElement(Title, {
    title: title,
    description: description
  })));
});
exports.PageHeader = PageHeader;
PageHeader.displayName = 'PageHeader';