"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMissingSignificantTerms = getMissingSignificantTerms;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMissingSignificantTerms(significantTerms, significantTermGroups) {
  return significantTerms.filter(cp => {
    return !significantTermGroups.some(cpg => {
      return cpg.group.some(d => d.fieldName === cp.fieldName && d.fieldValue === cp.fieldValue);
    });
  });
}