"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.categorizeFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _show_flyout = require("./show_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categorizeFieldAction = (coreStart, plugins) => (0, _public.createAction)({
  type: _public.ACTION_CATEGORIZE_FIELD,
  id: _public.ACTION_CATEGORIZE_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.aiops.categorizeFieldAction.displayName', {
    defaultMessage: 'Categorize field'
  }),
  isCompatible: async ({
    field
  }) => {
    var _field$esTypes;
    return ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('text')) === true;
  },
  execute: async context => {
    const {
      field,
      dataView
    } = context;
    (0, _show_flyout.showCategorizeFlyout)(field, dataView, coreStart, plugins);
  }
});
exports.categorizeFieldAction = categorizeFieldAction;