"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainLogRateSpikesPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _mlUrlState = require("@kbn/ml-url-state");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data = require("../../hooks/use_data");
var _use_search = require("../../hooks/use_search");
var _url_state = require("../../application/utils/url_state");
var _search_panel = require("../search_panel");
var _spike_analysis_table_row_provider = require("../spike_analysis_table/spike_analysis_table_row_provider");
var _page_header = require("../page_header");
var _explain_log_rate_spikes_content = require("./explain_log_rate_spikes_content/explain_log_rate_spikes_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplainLogRateSpikesPage = ({
  stickyHistogram
}) => {
  const {
    data: dataService
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView,
    savedSearch
  } = (0, _use_data_source.useDataSource)();
  const {
    currentSelectedSignificantTerm,
    currentSelectedGroup
  } = (0, _spike_analysis_table_row_provider.useSpikeAnalysisTableRowContext)();
  const [aiopsListState, setAiopsListState] = (0, _mlUrlState.usePageUrlState)('AIOPS_INDEX_VIEWER', (0, _url_state.getDefaultAiOpsListState)());
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [selectedSavedSearch, setSelectedSavedSearch] = (0, _react.useState)(savedSearch);
  (0, _react.useEffect)(() => {
    if (savedSearch) {
      setSelectedSavedSearch(savedSearch);
    }
  }, [savedSearch]);
  const setSearchParams = (0, _react.useCallback)(searchParams => {
    // When the user loads a saved search and then clears or modifies the query
    // we should remove the saved search and replace it with the index pattern id
    if (selectedSavedSearch !== null) {
      setSelectedSavedSearch(null);
    }
    setAiopsListState({
      ...aiopsListState,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [selectedSavedSearch, aiopsListState, setAiopsListState]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch
  }, aiopsListState);
  const {
    timefilter
  } = (0, _use_data.useData)(dataView, 'explain_log_rage_spikes', searchQuery, setGlobalState, currentSelectedSignificantTerm, currentSelectedGroup);
  (0, _react.useEffect)(
  // TODO: Consolidate this hook/function with with Data visualizer's
  function clearFiltersOnLeave() {
    return () => {
      // We want to clear all filters that have not been pinned globally
      // when navigating to other pages
      dataService.query.filterManager.getFilters().filter(f => {
        var _f$$state;
        return ((_f$$state = f.$state) === null || _f$$state === void 0 ? void 0 : _f$$state.store) === _esQuery.FilterStateStore.APP_STATE;
      }).forEach(f => dataService.query.filterManager.removeFilter(f));
    };
  }, [dataService.query.filterManager]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    // Update data query manager if input string is updated
    dataService === null || dataService === void 0 ? void 0 : dataService.query.queryString.setQuery({
      query: searchString !== null && searchString !== void 0 ? searchString : '',
      language: searchQueryLanguage
    });
  }, [dataService, searchQueryLanguage, searchString]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "aiopsExplainLogRateSpikesPage",
    paddingSize: "none",
    panelled: false
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_panel.SearchPanel, {
    dataView: dataView,
    searchString: searchString !== null && searchString !== void 0 ? searchString : '',
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams
  })), /*#__PURE__*/_react.default.createElement(_explain_log_rate_spikes_content.ExplainLogRateSpikesContent, {
    dataView: dataView,
    setGlobalState: setGlobalState,
    esSearchQuery: searchQuery,
    stickyHistogram: stickyHistogram
  }))));
};
exports.ExplainLogRateSpikesPage = ExplainLogRateSpikesPage;