"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainLogRateSpikesContent = void 0;
exports.getDocumentCountStatsSplitLabel = getDocumentCountStatsSplitLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_data = require("../../../hooks/use_data");
var _document_count_content = require("../../document_count_content/document_count_content");
var _explain_log_rate_spikes_analysis = require("../explain_log_rate_spikes_analysis");
var _spike_analysis_table_row_provider = require("../../spike_analysis_table/spike_analysis_table_row_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_QUERY = {
  match_all: {}
};
function getDocumentCountStatsSplitLabel(significantTerm, group) {
  if (significantTerm) {
    return `${significantTerm === null || significantTerm === void 0 ? void 0 : significantTerm.fieldName}:${significantTerm === null || significantTerm === void 0 ? void 0 : significantTerm.fieldValue}`;
  } else if (group) {
    return _i18n.i18n.translate('xpack.aiops.spikeAnalysisPage.documentCountStatsSplitGroupLabel', {
      defaultMessage: 'Selected group'
    });
  }
}
const ExplainLogRateSpikesContent = ({
  dataView,
  setGlobalState,
  initialAnalysisStart: incomingInitialAnalysisStart,
  timeRange,
  esSearchQuery = DEFAULT_SEARCH_QUERY,
  stickyHistogram,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted
}) => {
  const [windowParameters, setWindowParameters] = (0, _react.useState)();
  const [initialAnalysisStart, setInitialAnalysisStart] = (0, _react.useState)(incomingInitialAnalysisStart);
  const [isBrushCleared, setIsBrushCleared] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    setIsBrushCleared(windowParameters === undefined);
  }, [windowParameters]);
  const {
    currentSelectedSignificantTerm,
    currentSelectedGroup,
    setPinnedSignificantTerm,
    setPinnedGroup,
    setSelectedSignificantTerm,
    setSelectedGroup
  } = (0, _spike_analysis_table_row_provider.useSpikeAnalysisTableRowContext)();
  const {
    documentStats,
    earliest,
    latest
  } = (0, _use_data.useData)(dataView, 'explain_log_rage_spikes', esSearchQuery, setGlobalState, currentSelectedSignificantTerm, currentSelectedGroup, undefined, timeRange);
  const {
    sampleProbability,
    totalCount,
    documentCountStats,
    documentCountStatsCompare
  } = documentStats;
  function brushSelectionUpdate(d, force) {
    if (!isBrushCleared || force) {
      setWindowParameters(d);
    }
    if (force) {
      setIsBrushCleared(false);
    }
  }
  function clearSelection() {
    setWindowParameters(undefined);
    setPinnedSignificantTerm(null);
    setPinnedGroup(null);
    setSelectedSignificantTerm(null);
    setSelectedGroup(null);
    setIsBrushCleared(true);
    setInitialAnalysisStart(undefined);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, documentCountStats !== undefined && /*#__PURE__*/_react.default.createElement(_document_count_content.DocumentCountContent, {
    brushSelectionUpdateHandler: brushSelectionUpdate,
    documentCountStats: documentCountStats,
    documentCountStatsSplit: documentCountStatsCompare,
    documentCountStatsSplitLabel: getDocumentCountStatsSplitLabel(currentSelectedSignificantTerm, currentSelectedGroup),
    isBrushCleared: isBrushCleared,
    totalCount: totalCount,
    sampleProbability: sampleProbability,
    initialAnalysisStart: initialAnalysisStart,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), earliest !== undefined && latest !== undefined && windowParameters !== undefined && /*#__PURE__*/_react.default.createElement(_explain_log_rate_spikes_analysis.ExplainLogRateSpikesAnalysis, {
    dataView: dataView,
    earliest: earliest,
    isBrushCleared: isBrushCleared,
    latest: latest,
    stickyHistogram: stickyHistogram,
    onReset: clearSelection,
    sampleProbability: sampleProbability,
    searchQuery: esSearchQuery,
    windowParameters: windowParameters,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    onAnalysisCompleted: onAnalysisCompleted
  }), windowParameters === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.explainLogRateSpikesPage.emptyPromptTitle",
      defaultMessage: "Click a spike in the histogram chart to start the analysis."
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.explainLogRateSpikesPage.emptyPromptBody",
      defaultMessage: "The explain log rate spikes feature identifies statistically significant field/value combinations that contribute to a log rate spike."
    })),
    "data-test-subj": "aiopsNoWindowParametersEmptyPrompt"
  }));
};
exports.ExplainLogRateSpikesContent = ExplainLogRateSpikesContent;