"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCommonChartProps = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _esQuery = require("@kbn/es-query");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _react = require("react");
var _constants = require("./constants");
var _use_data_source = require("../../hooks/use_data_source");
var _change_point_detection_context = require("./change_point_detection_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides common props for the Lens Embeddable component
 */
const useCommonChartProps = ({
  annotation,
  fieldConfig,
  previewMode = false
}) => {
  var _annotation$group2;
  const timeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    bucketInterval,
    resultQuery,
    resultFilters
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();

  /**
   * In order to correctly render annotations for change points at the edges,
   * we need to adjust time bound based on the change point timestamp.
   */
  const chartTimeRange = (0, _react.useMemo)(() => {
    return {
      from: _moment.default.min((0, _moment.default)(timeRange.from), (0, _moment.default)(annotation.timestamp)).toISOString(),
      to: _moment.default.max((0, _moment.default)(timeRange.to), (0, _moment.default)(annotation.timestamp)).toISOString()
    };
  }, [timeRange, annotation.timestamp]);
  const filters = (0, _react.useMemo)(() => {
    return [...resultFilters, ...(annotation.group ? [{
      meta: {
        index: dataView.id,
        alias: null,
        negate: false,
        disabled: false,
        type: 'phrase',
        key: annotation.group.name,
        params: {
          query: annotation.group.value
        }
      },
      query: {
        match_phrase: {
          [annotation.group.name]: annotation.group.value
        }
      },
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      }
    }] : [])];
  }, [dataView.id, annotation.group, resultFilters]);
  const gridAndLabelsVisibility = !previewMode;
  const attributes = (0, _react.useMemo)(() => {
    var _annotation$group$val, _annotation$group;
    return {
      title: (_annotation$group$val = (_annotation$group = annotation.group) === null || _annotation$group === void 0 ? void 0 : _annotation$group.value) !== null && _annotation$group$val !== void 0 ? _annotation$group$val : '',
      description: '',
      visualizationType: 'lnsXY',
      type: 'lens',
      references: [{
        type: 'index-pattern',
        id: dataView.id,
        name: 'indexpattern-datasource-layer-2d61a885-abb0-4d4e-a5f9-c488caec3c22'
      }, {
        type: 'index-pattern',
        id: dataView.id,
        name: 'xy-visualization-layer-8d26ab67-b841-4877-9d02-55bf270f9caf'
      }],
      state: {
        visualization: {
          hideEndzones: true,
          yLeftExtent: {
            mode: 'dataBounds'
          },
          legend: {
            isVisible: false
          },
          valueLabels: 'hide',
          fittingFunction: 'None',
          // Updates per chart type
          axisTitlesVisibilitySettings: {
            x: gridAndLabelsVisibility,
            yLeft: gridAndLabelsVisibility,
            yRight: gridAndLabelsVisibility
          },
          tickLabelsVisibilitySettings: {
            x: gridAndLabelsVisibility,
            yLeft: gridAndLabelsVisibility,
            yRight: gridAndLabelsVisibility
          },
          labelsOrientation: {
            x: 0,
            yLeft: 0,
            yRight: 0
          },
          gridlinesVisibilitySettings: {
            x: gridAndLabelsVisibility,
            yLeft: gridAndLabelsVisibility,
            yRight: gridAndLabelsVisibility
          },
          preferredSeriesType: 'line',
          layers: [{
            layerId: '2d61a885-abb0-4d4e-a5f9-c488caec3c22',
            accessors: ['e9f26d17-fb36-4982-8539-03f1849cbed0'],
            position: 'top',
            seriesType: 'line',
            showGridlines: false,
            layerType: 'data',
            xAccessor: '877e6638-bfaa-43ec-afb9-2241dc8e1c86'
          },
          // Annotation layer
          {
            layerId: '8d26ab67-b841-4877-9d02-55bf270f9caf',
            layerType: 'annotations',
            annotations: [{
              type: 'manual',
              icon: 'triangle',
              textVisibility: gridAndLabelsVisibility,
              label: annotation.label,
              key: {
                type: 'point_in_time',
                timestamp: annotation.timestamp
              },
              id: 'a8fb297c-8d96-4011-93c0-45af110d5302',
              isHidden: false,
              color: '#F04E98',
              lineStyle: 'solid',
              lineWidth: 1,
              outside: false
            }],
            ignoreGlobalFilters: true
          }]
        },
        query: resultQuery,
        filters,
        datasourceStates: {
          formBased: {
            layers: {
              '2d61a885-abb0-4d4e-a5f9-c488caec3c22': {
                columns: {
                  '877e6638-bfaa-43ec-afb9-2241dc8e1c86': {
                    label: dataView.timeFieldName,
                    dataType: 'date',
                    operationType: 'date_histogram',
                    sourceField: dataView.timeFieldName,
                    isBucketed: true,
                    scale: 'interval',
                    params: {
                      interval: bucketInterval.expression,
                      includeEmptyRows: true,
                      dropPartials: false
                    }
                  },
                  'e9f26d17-fb36-4982-8539-03f1849cbed0': {
                    label: `${fieldConfig.fn}(${fieldConfig.metricField})`,
                    dataType: 'number',
                    operationType: _constants.fnOperationTypeMapping[fieldConfig.fn],
                    sourceField: fieldConfig.metricField,
                    isBucketed: false,
                    scale: 'ratio',
                    params: {
                      emptyAsNull: true
                    }
                  }
                },
                columnOrder: ['877e6638-bfaa-43ec-afb9-2241dc8e1c86', 'e9f26d17-fb36-4982-8539-03f1849cbed0'],
                incompleteColumns: {}
              }
            }
          },
          textBased: {
            layers: {}
          }
        }
      }
    };
  }, [(_annotation$group2 = annotation.group) === null || _annotation$group2 === void 0 ? void 0 : _annotation$group2.value, annotation.timestamp, annotation.label, dataView.id, dataView.timeFieldName, resultQuery, filters, bucketInterval.expression, fieldConfig.fn, fieldConfig.metricField, gridAndLabelsVisibility]);
  return {
    timeRange: chartTimeRange,
    filters,
    query: resultQuery,
    attributes
  };
};
exports.useCommonChartProps = useCommonChartProps;