"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_common_chart_props = require("./use_common_chart_props");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartComponent = /*#__PURE__*/_react.default.memo(({
  annotation,
  fieldConfig
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    filters,
    timeRange,
    query,
    attributes
  } = (0, _use_common_chart_props.useCommonChartProps)({
    fieldConfig,
    annotation
  });
  return /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: `changePointChart_${annotation.group ? annotation.group.value : annotation.label}`,
    style: {
      height: 350
    },
    timeRange: timeRange,
    query: query,
    filters: filters
    // @ts-ignore
    ,
    attributes: attributes,
    renderMode: 'view',
    executionContext: {
      type: 'aiops_change_point_detection_chart',
      name: 'Change point detection'
    },
    disableTriggers: true
  });
});
exports.ChartComponent = ChartComponent;