"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _component_registry = require("./component_registry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const component = new _component_registry.ComponentRegistry();
const title = _i18n.i18n.translate('advancedSettings.advancedSettingsLabel', {
  defaultMessage: 'Advanced Settings'
});
class AdvancedSettingsPlugin {
  setup(core, {
    management,
    home,
    usageCollection
  }) {
    const kibanaSection = management.sections.section.kibana;
    kibanaSection.registerApp({
      id: 'settings',
      title,
      order: 3,
      async mount(params) {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_app/mount_management_section')));
        return mountManagementSection(core.getStartServices, params, component.start, usageCollection);
      }
    });
    if (home) {
      home.featureCatalogue.register({
        id: 'advanced_settings',
        title,
        description: _i18n.i18n.translate('advancedSettings.featureCatalogueTitle', {
          defaultMessage: 'Customize your Kibana experience — change the date format, turn on dark mode, and more.'
        }),
        icon: 'gear',
        path: '/app/management/kibana/settings',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    return {
      component: component.setup
    };
  }
  start() {
    return {
      component: component.start
    };
  }
}
exports.AdvancedSettingsPlugin = AdvancedSettingsPlugin;