"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _page_title = require("./page_title");
var _page_subtitle = require("./page_subtitle");
var _page_footer = require("./page_footer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const componentType = {
  PAGE_TITLE_COMPONENT: 'advanced_settings_page_title',
  PAGE_SUBTITLE_COMPONENT: 'advanced_settings_page_subtitle',
  PAGE_FOOTER_COMPONENT: 'advanced_settings_page_footer'
};
class ComponentRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", {});
    (0, _defineProperty2.default)(this, "setup", {
      componentType: ComponentRegistry.componentType,
      /**
       * Attempts to register the provided component, with the ability to optionally allow
       * the component to override an existing one.
       *
       * If the intent is to override, then `allowOverride` must be set to true, otherwise an exception is thrown.
       *
       * @param id the id of the component to register
       * @param component the component
       * @param allowOverride (default: false) - optional flag to allow this component to override a previously registered component
       */
      register: (id, component, allowOverride = false) => {
        if (!allowOverride && id in this.registry) {
          throw new Error(`Component with id ${id} is already registered.`);
        }

        // Setting a display name if one does not already exist.
        // This enhances the snapshots, as well as the debugging experience.
        if (!component.displayName) {
          component.displayName = id;
        }
        this.registry[id] = component;
      }
    });
    (0, _defineProperty2.default)(this, "start", {
      componentType: ComponentRegistry.componentType,
      /**
       * Retrieve a registered component by its ID.
       * If the component does not exist, then an exception is thrown.
       *
       * @param id the ID of the component to retrieve
       */
      get: id => {
        return this.registry[id] || ComponentRegistry.defaultRegistry[id];
      }
    });
  }
}
exports.ComponentRegistry = ComponentRegistry;
(0, _defineProperty2.default)(ComponentRegistry, "componentType", componentType);
(0, _defineProperty2.default)(ComponentRegistry, "defaultRegistry", {
  advanced_settings_page_title: _page_title.PageTitle,
  advanced_settings_page_subtitle: _page_subtitle.PageSubtitle,
  advanced_settings_page_footer: _page_footer.PageFooter
});