"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.OTLPMetricExporterBase = exports.DeltaTemporalitySelector = exports.CumulativeTemporalitySelector = void 0;
const sdk_metrics_base_1 = require("@opentelemetry/sdk-metrics-base");
const OTLPMetricExporterOptions_1 = require("./OTLPMetricExporterOptions");
const CumulativeTemporalitySelector = () => sdk_metrics_base_1.AggregationTemporality.CUMULATIVE;
exports.CumulativeTemporalitySelector = CumulativeTemporalitySelector;
const DeltaTemporalitySelector = (instrumentType) => {
    switch (instrumentType) {
        case sdk_metrics_base_1.InstrumentType.COUNTER:
        case sdk_metrics_base_1.InstrumentType.OBSERVABLE_COUNTER:
        case sdk_metrics_base_1.InstrumentType.HISTOGRAM:
        case sdk_metrics_base_1.InstrumentType.OBSERVABLE_GAUGE:
            return sdk_metrics_base_1.AggregationTemporality.DELTA;
        case sdk_metrics_base_1.InstrumentType.UP_DOWN_COUNTER:
        case sdk_metrics_base_1.InstrumentType.OBSERVABLE_UP_DOWN_COUNTER:
            return sdk_metrics_base_1.AggregationTemporality.CUMULATIVE;
    }
};
exports.DeltaTemporalitySelector = DeltaTemporalitySelector;
function chooseTemporalitySelector(temporalityPreference) {
    if (temporalityPreference === sdk_metrics_base_1.AggregationTemporality.DELTA) {
        return exports.DeltaTemporalitySelector;
    }
    return exports.CumulativeTemporalitySelector;
}
class OTLPMetricExporterBase {
    constructor(exporter, config = OTLPMetricExporterOptions_1.defaultOptions) {
        this._otlpExporter = exporter;
        this._aggregationTemporalitySelector = chooseTemporalitySelector(config.temporalityPreference);
    }
    export(metrics, resultCallback) {
        this._otlpExporter.export([metrics], resultCallback);
    }
    async shutdown() {
        await this._otlpExporter.shutdown();
    }
    forceFlush() {
        return Promise.resolve();
    }
    selectAggregationTemporality(instrumentType) {
        return this._aggregationTemporalitySelector(instrumentType);
    }
}
exports.OTLPMetricExporterBase = OTLPMetricExporterBase;
//# sourceMappingURL=OTLPMetricExporterBase.js.map