"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JiraActionFields = ({
  action,
  editAction,
  errors,
  hasErrors,
  children
}) => {
  const {
    projectKey,
    issueType,
    summary
  } = action;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraProjectKey",
    errorKey: "projectKey",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && projectKey !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.projectKeyFieldLabel', {
      defaultMessage: 'Project key'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "projectKey",
    value: projectKey || '',
    "data-test-subj": "jiraProjectKeyInput",
    onChange: e => {
      editAction({
        key: 'projectKey',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!projectKey) {
        editAction({
          key: 'projectKey',
          value: ''
        });
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraIssueType",
    errorKey: "issueType",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && issueType !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.issueTypeFieldLabel', {
      defaultMessage: 'Issue type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: issueType || '',
    name: "issueType",
    "data-test-subj": "jiraIssueTypeInput",
    onChange: e => {
      editAction({
        key: 'issueType',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!issueType) {
        editAction({
          key: 'issueType',
          value: ''
        });
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraSummary",
    errorKey: "summary",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && summary !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.summaryFieldLabel', {
      defaultMessage: 'Summary'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: summary || '',
    name: "summary",
    "data-test-subj": "jiraSummaryInput",
    onChange: e => {
      editAction({
        key: 'summary',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!summary) {
        editAction({
          key: 'summary',
          value: ''
        });
      }
    }
  })));
};
exports.JiraActionFields = JiraActionFields;