"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringWatchEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _watch_context = require("../../watch_context");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitoringWatchEdit = ({
  pageTitle
}) => {
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const {
    history
  } = (0, _app_context.useAppContext)();
  const systemWatchMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.monitoring.edit.calloutDescriptionText",
    defaultMessage: "Watch '{watchName}' is a system watch and cannot be edited.",
    values: {
      watchName: watch.name
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    verticalPosition: "center",
    horizontalPosition: "center",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "",
    title: /*#__PURE__*/_react.default.createElement("h1", null, pageTitle),
    body: /*#__PURE__*/_react.default.createElement("p", null, systemWatchMessage),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, `/watches/watch/${watch.id}/status`), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.monitoring.header.watchLinkTitle",
      defaultMessage: "View watch status"
    }))]
  }));
};
exports.MonitoringWatchEdit = MonitoringWatchEdit;