"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Watch = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
var _json_watch = require("./json_watch");
var _threshold_watch = require("./threshold_watch");
var _monitoring_watch = require("./monitoring_watch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WatchTypes = {};
(0, _saferLodashSet.set)(WatchTypes, _constants.WATCH_TYPES.JSON, _json_watch.JsonWatch);
(0, _saferLodashSet.set)(WatchTypes, _constants.WATCH_TYPES.THRESHOLD, _threshold_watch.ThresholdWatch);
(0, _saferLodashSet.set)(WatchTypes, _constants.WATCH_TYPES.MONITORING, _monitoring_watch.MonitoringWatch);
class Watch {
  static fromUpstreamJson(upstreamWatch = {}) {
    const type = (0, _lodash.get)(upstreamWatch, 'type');
    const WatchType = WatchTypes[type];
    Object.assign(upstreamWatch, {
      isNew: false
    });
    return WatchType.fromUpstreamJson(upstreamWatch);
  }
}
exports.Watch = Watch;
(0, _defineProperty2.default)(Watch, "getWatchTypes", () => {
  return WatchTypes;
});