"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showNewVisModal = showNewVisModal;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const NewVisModal = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./new_vis_modal'))));
/**
 * shows modal dialog that allows you to create new visualization
 * @param {string[]} editorParams
 * @param {function} onClose - function that will be called when dialog is closed
 */
function showNewVisModal({
  editorParams = [],
  onClose,
  originatingApp,
  outsideVisualizeApp,
  showAggsSelection,
  selectedVisType
} = {}) {
  const container = document.createElement('div');
  let isClosed = false;
  const handleClose = () => {
    if (isClosed) return;
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    if (onClose) {
      onClose();
    }
    isClosed = true;
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: (0, _services.getTheme)().theme$
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      position: "fixed"
    }))
  }, /*#__PURE__*/_react.default.createElement(NewVisModal, {
    isOpen: true,
    onClose: handleClose,
    originatingApp: originatingApp,
    stateTransfer: (0, _services.getEmbeddable)().getStateTransfer(),
    outsideVisualizeApp: outsideVisualizeApp,
    editorParams: editorParams,
    visTypesRegistry: (0, _services.getTypes)(),
    addBasePath: (0, _services.getHttp)().basePath.prepend,
    uiSettings: (0, _services.getUISettings)(),
    http: (0, _services.getHttp)(),
    savedObjectsManagement: (0, _services.getSavedObjectsManagement)(),
    application: (0, _services.getApplication)(),
    docLinks: (0, _services.getDocLinks)(),
    showAggsSelection: showAggsSelection,
    selectedVisType: selectedVisType
  }))));
  _reactDom.default.render(element, container);
  return () => handleClose();
}