"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateBreadcrumbs = getCreateBreadcrumbs;
exports.getEditBreadcrumbs = getEditBreadcrumbs;
exports.getLandingBreadcrumbs = getLandingBreadcrumbs;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultEditText = _i18n.i18n.translate('visualizations.editor.defaultEditBreadcrumbText', {
  defaultMessage: 'Edit visualization'
});
function getLandingBreadcrumbs() {
  return [{
    text: _i18n.i18n.translate('visualizations.listing.breadcrumb', {
      defaultMessage: 'Visualize Library'
    }),
    href: `#${_constants.VisualizeConstants.LANDING_PAGE_PATH}`
  }];
}
function getCreateBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}) {
  return [...(originatingAppName ? [{
    text: originatingAppName,
    onClick: redirectToOrigin
  }] : []), ...(!byValue ? getLandingBreadcrumbs() : []), {
    text: _i18n.i18n.translate('visualizations.editor.createBreadcrumb', {
      defaultMessage: 'Create'
    })
  }];
}
function getEditBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}, title = defaultEditText) {
  return [...(originatingAppName ? [{
    text: originatingAppName,
    onClick: redirectToOrigin
  }] : []), ...(!byValue ? getLandingBreadcrumbs() : []), {
    text: title
  }];
}