"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeListing = void 0;
require("./visualize_listing.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _contentManagementTableList = require("@kbn/content-management-table-list");
var _saved_visualize_utils = require("../../utils/saved_visualize_utils");
var _update_basic_attributes = require("../../utils/saved_objects_utils/update_basic_attributes");
var _check_for_duplicate_title = require("../../utils/saved_objects_utils/check_for_duplicate_title");
var _wizard = require("../../wizard");
var _services = require("../../services");
var _ = require("../..");
var _constants = require("../../../common/constants");
var _utils = require("../utils");
var _get_visualize_list_item_link = require("../utils/get_visualize_list_item_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const toTableListViewSavedObject = savedObject => {
  var _ref, _ref2, _ref3;
  return {
    id: savedObject.id,
    updatedAt: savedObject.updatedAt,
    references: savedObject.references,
    type: savedObject.savedObjectType,
    editUrl: savedObject.editUrl,
    editApp: savedObject.editApp,
    icon: savedObject.icon,
    stage: savedObject.stage,
    savedObjectType: savedObject.savedObjectType,
    typeTitle: savedObject.typeTitle,
    title: (_ref = savedObject.title) !== null && _ref !== void 0 ? _ref : '',
    error: (_ref2 = savedObject.error) !== null && _ref2 !== void 0 ? _ref2 : '',
    attributes: {
      title: (_ref3 = savedObject.title) !== null && _ref3 !== void 0 ? _ref3 : '',
      description: savedObject.description,
      editApp: savedObject.editApp,
      editUrl: savedObject.editUrl,
      error: savedObject.error
    }
  };
};
const VisualizeListing = () => {
  const {
    services: {
      core,
      application,
      executionContext,
      chrome,
      history,
      toastNotifications,
      stateTransferService,
      savedObjects,
      uiSettings,
      visualizeCapabilities,
      dashboardCapabilities,
      kbnUrlStateStorage,
      overlays,
      savedObjectsTagging
    }
  } = (0, _public.useKibana)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const closeNewVisModal = (0, _react.useRef)(() => {});
  const visualizedUserContent = (0, _react.useRef)();
  const listingLimit = uiSettings.get(_.SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = uiSettings.get(_.SAVED_OBJECTS_PER_PAGE_SETTING);
  (0, _public.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'list'
  });
  (0, _react.useEffect)(() => {
    if (pathname === '/new') {
      // In case the user navigated to the page via the /visualize/new URL we start the dialog immediately
      closeNewVisModal.current = (0, _wizard.showNewVisModal)({
        onClose: () => {
          // In case the user came via a URL to this page, change the URL to the regular landing page URL after closing the modal
          history.push(_constants.VisualizeConstants.LANDING_PAGE_PATH);
        }
      });
    } else {
      // close modal window if exists
      closeNewVisModal.current();
    }
  }, [history, pathname]);
  (0, _useMount.default)(() => {
    // Reset editor state for all apps if the visualize listing page is loaded.
    stateTransferService.clearEditorState();
    chrome.setBreadcrumbs([{
      text: _i18n.i18n.translate('visualizations.visualizeListingBreadcrumbsTitle', {
        defaultMessage: 'Visualize Library'
      })
    }]);
    chrome.docTitle.change(_i18n.i18n.translate('visualizations.listingPageTitle', {
      defaultMessage: 'Visualize Library'
    }));
  });
  (0, _useUnmount.default)(() => closeNewVisModal.current());
  const createNewVis = (0, _react.useCallback)(() => {
    closeNewVisModal.current = (0, _wizard.showNewVisModal)();
  }, []);
  const editItem = (0, _react.useCallback)(({
    attributes: {
      editUrl,
      editApp
    }
  }) => {
    if (editApp) {
      application.navigateToApp(editApp, {
        path: editUrl
      });
      return;
    }
    // for visualizations the edit and view URLs are the same
    history.push(editUrl);
  }, [application, history]);
  const noItemsFragment = (0, _react.useMemo)(() => (0, _utils.getNoItemsMessage)(createNewVis), [createNewVis]);
  const fetchItems = (0, _react.useCallback)((searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    const isLabsEnabled = uiSettings.get(_.VISUALIZE_ENABLE_LABS_SETTING);
    return (0, _saved_visualize_utils.findListItems)(savedObjects.client, (0, _services.getTypes)(), searchTerm, listingLimit, references, referencesToExclude).then(({
      total,
      hits
    }) => {
      const content = hits.filter(result => {
        var _result$type;
        return isLabsEnabled || ((_result$type = result.type) === null || _result$type === void 0 ? void 0 : _result$type.stage) !== 'experimental';
      }).map(toTableListViewSavedObject);
      visualizedUserContent.current = content;
      return {
        total,
        hits: content
      };
    });
  }, [listingLimit, uiSettings, savedObjects.client]);
  const onContentEditorSave = (0, _react.useCallback)(async args => {
    var _visualizedUserConten;
    const content = (_visualizedUserConten = visualizedUserContent.current) === null || _visualizedUserConten === void 0 ? void 0 : _visualizedUserConten.find(({
      id
    }) => id === args.id);
    if (content) {
      var _args$description;
      await (0, _update_basic_attributes.updateBasicSoAttributes)(content.id, content.type, {
        title: args.title,
        description: (_args$description = args.description) !== null && _args$description !== void 0 ? _args$description : '',
        tags: args.tags
      }, {
        savedObjectsClient: savedObjects.client,
        overlays,
        savedObjectsTagging
      });
    }
  }, [overlays, savedObjects.client, savedObjectsTagging]);
  const contentEditorValidators = (0, _react.useMemo)(() => ({
    title: [{
      type: 'warning',
      async fn(value, id) {
        if (id) {
          var _visualizedUserConten2;
          const content = (_visualizedUserConten2 = visualizedUserContent.current) === null || _visualizedUserConten2 === void 0 ? void 0 : _visualizedUserConten2.find(c => c.id === id);
          if (content) {
            try {
              await (0, _check_for_duplicate_title.checkForDuplicateTitle)({
                id,
                title: value,
                lastSavedTitle: content.title,
                getEsType: () => content.type
              }, false, false, () => {}, {
                savedObjectsClient: savedObjects.client,
                overlays
              });
            } catch (e) {
              return _i18n.i18n.translate('visualizations.visualizeListingDeleteErrorTitle.duplicateWarning', {
                defaultMessage: 'Saving "{value}" creates a duplicate title.',
                values: {
                  value
                }
              });
            }
          }
        }
      }
    }]
  }), [overlays, savedObjects.client]);
  const deleteItems = (0, _react.useCallback)(async selectedItems => {
    await Promise.all(selectedItems.map(item => savedObjects.client.delete(item.savedObjectType, item.id))).catch(error => {
      toastNotifications.addError(error, {
        title: _i18n.i18n.translate('visualizations.visualizeListingDeleteErrorTitle', {
          defaultMessage: 'Error deleting visualization'
        })
      });
    });
  }, [savedObjects.client, toastNotifications]);
  const calloutMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "visualize-dashboard-flow-prompt",
    id: "visualizations.visualizeListingDashboardFlowDescription",
    defaultMessage: "Building a dashboard? Create and add your visualizations right from the {dashboardApp}.",
    values: {
      dashboardApp: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        className: "visListingCallout__link",
        onClick: event => {
          event.preventDefault();
          application.navigateToUrl(application.getUrlForApp('dashboards'));
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.visualizeListingDashboardAppName",
        defaultMessage: "Dashboard application"
      }))
    }
  });
  return /*#__PURE__*/_react.default.createElement(_contentManagementTableList.TableListView, {
    id: "vis",
    headingId: "visualizeListingHeading"
    // we allow users to create visualizations even if they can't save them
    // for data exploration purposes
    ,
    createItem: createNewVis,
    findItems: fetchItems,
    deleteItems: visualizeCapabilities.delete ? deleteItems : undefined,
    editItem: visualizeCapabilities.save ? editItem : undefined,
    customTableColumn: (0, _utils.getCustomColumn)(),
    listingLimit: listingLimit,
    initialPageSize: initialPageSize,
    initialFilter: '',
    contentEditor: {
      isReadonly: !visualizeCapabilities.save,
      onSave: onContentEditorSave,
      customValidators: contentEditorValidators
    },
    emptyPrompt: noItemsFragment,
    entityName: _i18n.i18n.translate('visualizations.listing.table.entityName', {
      defaultMessage: 'visualization'
    }),
    entityNamePlural: _i18n.i18n.translate('visualizations.listing.table.entityNamePlural', {
      defaultMessage: 'visualizations'
    }),
    tableListTitle: _i18n.i18n.translate('visualizations.listing.table.listTitle', {
      defaultMessage: 'Visualize Library'
    }),
    getDetailViewLink: ({
      attributes: {
        editApp,
        editUrl,
        error
      }
    }) => (0, _get_visualize_list_item_link.getVisualizeListItemLink)(core.application, kbnUrlStateStorage, editApp, editUrl, error)
  }, dashboardCapabilities.createNew && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: calloutMessage,
    iconType: "iInCircle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
exports.VisualizeListing = VisualizeListing;