"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeEditor = void 0;
require("./visualize_editor.scss");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _events = require("events");
var _public = require("@kbn/kibana-react-plugin/public");
var _utils = require("../utils");
var _visualize_editor_common = require("./visualize_editor_common");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VisualizeEditor = ({
  onAppLeave
}) => {
  const {
    id: visualizationIdFromUrl
  } = (0, _reactRouterDom.useParams)();
  const [originatingApp, setOriginatingApp] = (0, _react.useState)();
  const [originatingPath, setOriginatingPath] = (0, _react.useState)();
  const [embeddableIdValue, setEmbeddableId] = (0, _react.useState)();
  const [embeddableInput, setEmbeddableInput] = (0, _react.useState)();
  const {
    services
  } = (0, _public.useKibana)();
  const [eventEmitter] = (0, _react.useState)(new _events.EventEmitter());
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(!visualizationIdFromUrl);
  const isChromeVisible = (0, _utils.useChromeVisibility)(services.chrome);
  (0, _react.useEffect)(() => {
    const {
      stateTransferService,
      data
    } = services;
    const {
      originatingApp: value,
      searchSessionId,
      embeddableId,
      originatingPath: pathValue,
      valueInput: valueInputValue
    } = stateTransferService.getIncomingEditorState(_constants.VisualizeConstants.APP_ID) || {};
    if (searchSessionId) {
      data.search.session.continue(searchSessionId);
    } else {
      data.search.session.start();
    }
    setEmbeddableInput(valueInputValue);
    setEmbeddableId(embeddableId);
    setOriginatingApp(value);
    setOriginatingPath(pathValue);
  }, [services]);
  const {
    savedVisInstance,
    visEditorRef,
    visEditorController
  } = (0, _utils.useSavedVisInstance)(services, eventEmitter, isChromeVisible, originatingApp, visualizationIdFromUrl, embeddableInput);
  const editorName = (savedVisInstance === null || savedVisInstance === void 0 ? void 0 : savedVisInstance.vis.type.title.toLowerCase().replace(' ', '_')) || '';
  (0, _public.useExecutionContext)(services.executionContext, {
    type: 'application',
    page: `editor${editorName ? `:${editorName}` : ''}`,
    id: visualizationIdFromUrl || 'new'
  });
  const {
    appState,
    hasUnappliedChanges
  } = (0, _utils.useVisualizeAppState)(services, eventEmitter, savedVisInstance);
  const {
    isEmbeddableRendered,
    currentAppState
  } = (0, _utils.useEditorUpdates)(services, eventEmitter, setHasUnsavedChanges, appState, savedVisInstance, visEditorController);
  (0, _utils.useLinkedSearchUpdates)(services, eventEmitter, appState, savedVisInstance);
  (0, _utils.useDataViewUpdates)(services, eventEmitter, appState, savedVisInstance);
  (0, _react.useEffect)(() => {
    // clean up all registered listeners if any is left
    return () => {
      eventEmitter.removeAllListeners();
    };
  }, [eventEmitter, services]);
  return /*#__PURE__*/_react.default.createElement(_visualize_editor_common.VisualizeEditorCommon, {
    visInstance: savedVisInstance,
    appState: appState,
    currentAppState: currentAppState,
    isChromeVisible: isChromeVisible,
    hasUnsavedChanges: hasUnsavedChanges,
    hasUnappliedChanges: hasUnappliedChanges,
    isEmbeddableRendered: isEmbeddableRendered,
    originatingApp: originatingApp,
    setOriginatingApp: setOriginatingApp,
    originatingPath: originatingPath,
    visualizationIdFromUrl: visualizationIdFromUrl,
    setHasUnsavedChanges: setHasUnsavedChanges,
    visEditorRef: visEditorRef,
    onAppLeave: onAppLeave,
    embeddableId: embeddableIdValue,
    eventEmitter: eventEmitter
  });
};
exports.VisualizeEditor = VisualizeEditor;