"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoComponent = exports.ExperimentalVisInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const InfoComponent = () => {
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.experimentalVisInfoTitle",
    defaultMessage: "This functionality is in technical preview."
  });
  const text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.experimentalVisInfoText",
    defaultMessage: "It may be changed or removed completely in a future release. Elastic will take a best effort approach to fix any issues, but features in technical preview are not subject to the support SLA of official GA features. For feedback, please create an issue in {githubLink}.",
    values: {
      githubLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: "https://github.com/elastic/kibana/issues/new/choose",
        target: "_blank"
      }, "GitHub")
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    className: "hide-for-sharing",
    "data-test-subj": "experimentalVisInfo",
    size: "s",
    title: title,
    iconType: "beaker"
  }, text);
};
exports.InfoComponent = InfoComponent;
const ExperimentalVisInfo = /*#__PURE__*/(0, _react.memo)(InfoComponent);
exports.ExperimentalVisInfo = ExperimentalVisInfo;