"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visTypeAliasRegistry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let registry = [];
const discardOnRegister = [];
const visTypeAliasRegistry = {
  get: () => [...registry],
  add: newVisTypeAlias => {
    if (registry.find(visTypeAlias => visTypeAlias.name === newVisTypeAlias.name)) {
      throw new Error(`${newVisTypeAlias.name} already registered`);
    }
    // if it exists on discardOnRegister array then we don't allow it to be registered
    const isToBeDiscarded = discardOnRegister.some(aliasName => aliasName === newVisTypeAlias.name);
    if (!isToBeDiscarded) {
      registry.push(newVisTypeAlias);
    }
  },
  remove: visTypeAliasName => {
    const isAliasPresent = registry.find(visTypeAlias => visTypeAlias.name === visTypeAliasName);
    // in case the alias has not registered yet we store it on an array, in order to not allow it to
    // be registered in case of a race condition
    if (!isAliasPresent) {
      discardOnRegister.push(visTypeAliasName);
    } else {
      registry = registry.filter(visTypeAlias => visTypeAlias.name !== visTypeAliasName);
    }
  }
};
exports.visTypeAliasRegistry = visTypeAliasRegistry;