"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Schemas = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireWildcard(require("lodash"));
var _public = require("@kbn/data-plugin/public");
let _AggGroupNames$Bucket, _AggGroupNames$Metric;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
_AggGroupNames$Bucket = _public.AggGroupNames.Buckets;
_AggGroupNames$Metric = _public.AggGroupNames.Metrics;
/** @private **/
class Schemas {
  constructor(schemas) {
    (0, _defineProperty2.default)(this, "all", []);
    (0, _defineProperty2.default)(this, _AggGroupNames$Bucket, []);
    (0, _defineProperty2.default)(this, _AggGroupNames$Metric, []);
    (0, _lodash.default)(schemas || []).chain().map(schema => {
      if (!schema.name) throw new Error('all schema must have a unique name');
      if (schema.name === 'split') {
        schema.params = [{
          name: 'row',
          default: true
        }];
      }
      (0, _lodash.defaults)(schema, {
        min: 0,
        max: Infinity,
        group: _public.AggGroupNames.Buckets,
        title: schema.name,
        aggFilter: '*',
        params: []
      });
      return schema;
    }).tap(fullSchemas => {
      this.all = fullSchemas;
    }).groupBy('group').forOwn((group, groupName) => {
      // @ts-ignore
      this[groupName] = group;
    }).commit();
  }
}
exports.Schemas = Schemas;