"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmModalPromise = confirmModalPromise;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function confirmModalPromise(message = '', title = '', confirmBtnText = '', overlays) {
  return new Promise((resolve, reject) => {
    const cancelButtonText = _i18n.i18n.translate('visualizations.confirmModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    });
    const modal = overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      onCancel: () => {
        modal.close();
        reject();
      },
      onConfirm: () => {
        modal.close();
        resolve(true);
      },
      confirmButtonText: confirmBtnText,
      cancelButtonText: cancelButtonText,
      title: title
    }, message)));
  });
}