"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeEditorTrigger = exports.dashboardVisualizationPanelTrigger = exports.aggBasedVisualizationTrigger = exports.VISUALIZE_EDITOR_TRIGGER = exports.DASHBOARD_VISUALIZATION_PANEL_TRIGGER = exports.AGG_BASED_VISUALIZATION_TRIGGER = exports.ACTION_CONVERT_TO_LENS = exports.ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS = exports.ACTION_CONVERT_AGG_BASED_TO_LENS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VISUALIZE_EDITOR_TRIGGER = 'VISUALIZE_EDITOR_TRIGGER';
exports.VISUALIZE_EDITOR_TRIGGER = VISUALIZE_EDITOR_TRIGGER;
const visualizeEditorTrigger = {
  id: VISUALIZE_EDITOR_TRIGGER,
  title: 'Convert TSVB to Lens',
  description: 'Triggered when user navigates from a TSVB to Lens.'
};
exports.visualizeEditorTrigger = visualizeEditorTrigger;
const AGG_BASED_VISUALIZATION_TRIGGER = 'AGG_BASED_VISUALIZATION_TRIGGER';
exports.AGG_BASED_VISUALIZATION_TRIGGER = AGG_BASED_VISUALIZATION_TRIGGER;
const aggBasedVisualizationTrigger = {
  id: AGG_BASED_VISUALIZATION_TRIGGER,
  title: 'Convert legacy agg based visualizations to Lens',
  description: 'Triggered when user navigates from a agg based visualization to Lens.'
};
exports.aggBasedVisualizationTrigger = aggBasedVisualizationTrigger;
const DASHBOARD_VISUALIZATION_PANEL_TRIGGER = 'DASHBOARD_VISUALIZATION_PANEL_TRIGGER';
exports.DASHBOARD_VISUALIZATION_PANEL_TRIGGER = DASHBOARD_VISUALIZATION_PANEL_TRIGGER;
const dashboardVisualizationPanelTrigger = {
  id: DASHBOARD_VISUALIZATION_PANEL_TRIGGER,
  title: 'Convert legacy visualization panel on dashboard to Lens',
  description: 'Triggered when user use "Edit in Lens" action on dashboard panel'
};
exports.dashboardVisualizationPanelTrigger = dashboardVisualizationPanelTrigger;
const ACTION_CONVERT_TO_LENS = 'ACTION_CONVERT_TO_LENS';
exports.ACTION_CONVERT_TO_LENS = ACTION_CONVERT_TO_LENS;
const ACTION_CONVERT_AGG_BASED_TO_LENS = 'ACTION_CONVERT_AGG_BASED_TO_LENS';
exports.ACTION_CONVERT_AGG_BASED_TO_LENS = ACTION_CONVERT_AGG_BASED_TO_LENS;
const ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS = 'ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS';
exports.ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS = ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS;