"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _check_for_duplicate_title = require("../utils/saved_objects_utils/check_for_duplicate_title");
var _constants = require("./constants");
var _vis_async = require("../vis_async");
var _services = require("../services");
var _wizard = require("../wizard");
var _saved_visualize_utils = require("../utils/saved_visualize_utils");
var _saved_visualization_references = require("../utils/saved_visualization_references");
var _create_vis_embeddable_from_object = require("./create_vis_embeddable_from_object");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class VisualizeEmbeddableFactory {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "type", _constants.VISUALIZE_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "attributeService", void 0);
    (0, _defineProperty2.default)(this, "savedObjectMetaData", {
      name: _i18n.i18n.translate('visualizations.savedObjectName', {
        defaultMessage: 'Visualization'
      }),
      includeFields: ['visState'],
      type: 'visualization',
      getIconForSavedObject: savedObject => {
        var _getTypes$get;
        return ((_getTypes$get = (0, _services.getTypes)().get(JSON.parse(savedObject.attributes.visState).type)) === null || _getTypes$get === void 0 ? void 0 : _getTypes$get.icon) || 'visualizeApp';
      },
      getTooltipForSavedObject: savedObject => {
        var _getTypes$get2;
        return `${savedObject.attributes.title} (${(_getTypes$get2 = (0, _services.getTypes)().get(JSON.parse(savedObject.attributes.visState).type)) === null || _getTypes$get2 === void 0 ? void 0 : _getTypes$get2.title})`;
      },
      showSavedObject: savedObject => {
        try {
          const typeName = JSON.parse(savedObject.attributes.visState).type;
          const visType = (0, _services.getTypes)().get(typeName);
          if (!visType) {
            return false;
          }
          if ((0, _services.getUISettings)().get(_constants2.VISUALIZE_ENABLE_LABS_SETTING)) {
            return true;
          }
          return visType.stage !== 'experimental';
        } catch {
          return false;
        }
      },
      getSavedObjectSubType: savedObject => {
        return JSON.parse(savedObject.attributes.visState).type;
      }
    });
    this.deps = deps;
  }
  async isEditable() {
    return (0, _services.getCapabilities)().visualize.save;
  }
  getDisplayName() {
    return _i18n.i18n.translate('visualizations.displayName', {
      defaultMessage: 'visualization'
    });
  }
  async getCurrentAppId() {
    return await this.deps.start().core.application.currentAppId$.pipe((0, _operators.first)()).toPromise();
  }
  async getAttributeService() {
    if (!this.attributeService) {
      this.attributeService = await this.deps.start().plugins.embeddable.getAttributeService(this.type, {
        saveMethod: this.saveMethod.bind(this),
        checkForDuplicateTitle: this.checkTitle.bind(this)
      });
    }
    return this.attributeService;
  }
  async createFromSavedObject(savedObjectId, input, parent) {
    const startDeps = await this.deps.start();
    try {
      var _startDeps$plugins$sa, _savedObject$sharingS;
      const savedObject = await (0, _saved_visualize_utils.getSavedVisualization)({
        savedObjectsClient: startDeps.core.savedObjects.client,
        search: startDeps.plugins.data.search,
        dataViews: startDeps.plugins.data.dataViews,
        spaces: startDeps.plugins.spaces,
        savedObjectsTagging: (_startDeps$plugins$sa = startDeps.plugins.savedObjectsTaggingOss) === null || _startDeps$plugins$sa === void 0 ? void 0 : _startDeps$plugins$sa.getTaggingApi()
      }, savedObjectId);
      if (((_savedObject$sharingS = savedObject.sharingSavedObjectProps) === null || _savedObject$sharingS === void 0 ? void 0 : _savedObject$sharingS.outcome) === 'conflict') {
        var _savedObject$sharingS2;
        return new _public2.ErrorEmbeddable(_i18n.i18n.translate('visualizations.embeddable.legacyURLConflict.errorMessage', {
          defaultMessage: `This visualization has the same URL as a legacy alias. Disable the alias to resolve this error : {json}`,
          values: {
            json: (_savedObject$sharingS2 = savedObject.sharingSavedObjectProps) === null || _savedObject$sharingS2 === void 0 ? void 0 : _savedObject$sharingS2.errorJSON
          }
        }), input, parent);
      }
      const visState = (0, _saved_visualize_utils.convertToSerializedVis)(savedObject);
      const vis = await (0, _vis_async.createVisAsync)(savedObject.visState.type, visState);
      return (0, _create_vis_embeddable_from_object.createVisEmbeddableFromObject)(this.deps)(vis, input, await this.getAttributeService(), parent);
    } catch (e) {
      console.error(e); // eslint-disable-line no-console
      return new _public2.ErrorEmbeddable(e, input, parent);
    }
  }
  async create(input, parent) {
    // TODO: This is a bit of a hack to preserve the original functionality. Ideally we will clean this up
    // to allow for in place creation of visualizations without having to navigate away to a new URL.
    if (input.savedVis) {
      const visState = input.savedVis;
      const vis = await (0, _vis_async.createVisAsync)(visState.type, visState);
      return (0, _create_vis_embeddable_from_object.createVisEmbeddableFromObject)(this.deps)(vis, input, await this.getAttributeService(), parent);
    } else {
      (0, _wizard.showNewVisModal)({
        originatingApp: await this.getCurrentAppId(),
        outsideVisualizeApp: true
      });
      return undefined;
    }
  }
  async saveMethod(attributes) {
    try {
      var _visObj$data$searchSo, _plugins$savedObjects;
      const {
        title,
        savedVis
      } = attributes;
      const visObj = attributes.vis;
      if (!savedVis) {
        throw new Error('No Saved Vis');
      }
      const saveOptions = {
        confirmOverwrite: false,
        returnToOrigin: true,
        isTitleDuplicateConfirmed: true,
        copyOnSave: false
      };
      savedVis.title = title;
      savedVis.description = '';
      savedVis.searchSourceFields = visObj === null || visObj === void 0 ? void 0 : (_visObj$data$searchSo = visObj.data.searchSource) === null || _visObj$data$searchSo === void 0 ? void 0 : _visObj$data$searchSo.getSerializedFields();
      savedVis.savedSearchId = visObj === null || visObj === void 0 ? void 0 : visObj.data.savedSearchId;
      const serializedVis = visObj.serialize();
      const {
        params,
        data
      } = serializedVis;
      savedVis.visState = {
        title,
        type: serializedVis.type,
        params,
        aggs: data.aggs
      };
      if (visObj) {
        savedVis.uiStateJSON = visObj === null || visObj === void 0 ? void 0 : visObj.uiState.toString();
      }
      const {
        core,
        plugins
      } = await this.deps.start();
      const id = await (0, _saved_visualize_utils.saveVisualization)(savedVis, saveOptions, {
        savedObjectsClient: core.savedObjects.client,
        overlays: core.overlays,
        savedObjectsTagging: (_plugins$savedObjects = plugins.savedObjectsTaggingOss) === null || _plugins$savedObjects === void 0 ? void 0 : _plugins$savedObjects.getTaggingApi()
      });
      if (!id || id === '') {
        throw new Error(_i18n.i18n.translate('visualizations.savingVisualizationFailed.errorMsg', {
          defaultMessage: 'Saving a visualization failed'
        }));
      }
      core.chrome.recentlyAccessed.add((0, _saved_visualize_utils.getFullPath)(id), savedVis.title, String(id));
      return {
        id
      };
    } catch (error) {
      throw error;
    }
  }
  async checkTitle(props) {
    const savedObjectsClient = await this.deps.start().core.savedObjects.client;
    const overlays = await this.deps.start().core.overlays;
    return (0, _check_for_duplicate_title.checkForDuplicateTitle)({
      title: props.newTitle,
      lastSavedTitle: '',
      getEsType: () => this.type
    }, false, props.isTitleDuplicateConfirmed, props.onTitleDuplicate, {
      savedObjectsClient,
      overlays
    });
  }
  inject(_state, references) {
    var _state$savedVis, _state$savedVis2;
    let state = _state;
    const {
      type,
      params
    } = (_state$savedVis = state.savedVis) !== null && _state$savedVis !== void 0 ? _state$savedVis : {};
    if (type && params) {
      (0, _saved_visualization_references.injectControlsReferences)(type, params, references);
      (0, _saved_visualization_references.injectTimeSeriesReferences)(type, params, references);
    }
    if ((_state$savedVis2 = state.savedVis) !== null && _state$savedVis2 !== void 0 && _state$savedVis2.data.searchSource) {
      var _state$savedVis3, _references$find;
      let extractedSearchSource = (_state$savedVis3 = state.savedVis) === null || _state$savedVis3 === void 0 ? void 0 : _state$savedVis3.data.searchSource;
      if (!('indexRefName' in state.savedVis.data.searchSource)) {
        // due to a bug in 8.0, some visualizations were saved with an injected state - re-extract in that case and inject the upstream references because they might have changed
        extractedSearchSource = (0, _public.extractSearchSourceReferences)(extractedSearchSource)[0];
      }
      const injectedSearchSource = (0, _public.injectSearchSourceReferences)(extractedSearchSource, references);
      state = {
        ...state,
        savedVis: {
          ...state.savedVis,
          data: {
            ...state.savedVis.data,
            searchSource: injectedSearchSource,
            savedSearchId: (_references$find = references.find(r => r.name === 'search_0')) === null || _references$find === void 0 ? void 0 : _references$find.id
          }
        }
      };
    }
    return state;
  }
  extract(_state) {
    var _state$savedVis4, _state$savedVis5, _state$savedVis6;
    let state = _state;
    const references = [];
    if ((_state$savedVis4 = state.savedVis) !== null && _state$savedVis4 !== void 0 && _state$savedVis4.data.savedSearchId) {
      references.push({
        name: 'search_0',
        type: 'search',
        id: String(state.savedVis.data.savedSearchId)
      });
    }
    if ((_state$savedVis5 = state.savedVis) !== null && _state$savedVis5 !== void 0 && _state$savedVis5.data.searchSource) {
      const [extractedSearchSource, searchSourceReferences] = (0, _public.extractSearchSourceReferences)(state.savedVis.data.searchSource);
      references.push(...searchSourceReferences);
      state = {
        ...state,
        savedVis: {
          ...state.savedVis,
          data: {
            ...state.savedVis.data,
            searchSource: extractedSearchSource,
            savedSearchId: undefined
          }
        }
      };
    }
    const {
      type,
      params
    } = (_state$savedVis6 = state.savedVis) !== null && _state$savedVis6 !== void 0 ? _state$savedVis6 : {};
    if (type && params) {
      (0, _saved_visualization_references.extractControlsReferences)(type, params, references, `control_${state.id}`);
      (0, _saved_visualization_references.extractTimeSeriesReferences)(type, params, references, `metrics_${state.id}`);
    }
    return {
      state: state,
      references
    };
  }
}
exports.VisualizeEmbeddableFactory = VisualizeEmbeddableFactory;