"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisabledLabVisualization = DisabledLabVisualization;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DisabledLabVisualization({
  title
}) {
  const advancedSettingsLink = (0, _services.getDocLinks)().links.management.visualizationSettings;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.disabledLabVisualizationTitle",
      defaultMessage: "{title} is a lab visualization.",
      values: {
        title
      }
    })),
    iconType: "beaker",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.disabledLabVisualizationMessage",
      defaultMessage: "Please turn on lab-mode in the advanced settings to see lab visualizations."
    }),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      external: true,
      href: advancedSettingsLink
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.disabledLabVisualizationLink",
      defaultMessage: "Read documentation"
    }))
  }));
}