"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisabledLabEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _disabled_lab_visualization = require("./disabled_lab_visualization");
var _constants = require("./constants");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DisabledLabEmbeddable extends _public2.Embeddable {
  constructor(title, initialInput) {
    super(initialInput, {
      title
    });
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "type", _constants.VISUALIZE_EMBEDDABLE_TYPE);
    this.title = title;
  }
  reload() {}
  render(domNode) {
    if (this.title) {
      this.domNode = domNode;
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
        theme$: (0, _services.getTheme)().theme$
      }, /*#__PURE__*/_react.default.createElement(_disabled_lab_visualization.DisabledLabVisualization, {
        title: this.title
      })), domNode);
    }
  }
  destroy() {
    if (this.domNode) {
      _reactDom.default.unmountComponentAtNode(this.domNode);
    }
  }
}
exports.DisabledLabEmbeddable = DisabledLabEmbeddable;