"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visTypesDefinitions = void 0;
var _area = require("./area");
var _line = require("./line");
var _histogram = require("./histogram");
var _horizontal_bar = require("./horizontal_bar");
var _convert_to_lens = require("../convert_to_lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const visTypesDefinitions = [_area.areaVisTypeDefinition, _line.lineVisTypeDefinition, _histogram.histogramVisTypeDefinition, _horizontal_bar.horizontalBarVisTypeDefinition].map(defenition => {
  return {
    ...defenition,
    navigateToLens: async (vis, timefilter) => vis ? (0, _convert_to_lens.convertToLens)(vis, timefilter) : null,
    getExpressionVariables: async (vis, timeFilter) => {
      return {
        canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await (0, _convert_to_lens.convertToLens)(vis, timeFilter) : null)
      };
    }
  };
});
exports.visTypesDefinitions = visTypesDefinitions;