"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = exports.isDateHistogramParams = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _public3 = require("@kbn/data-plugin/public");
var _types = require("./types");
var _common = require("../common");
var _get_series_params = require("./utils/get_series_params");
var _accessors = require("./utils/accessors");
var _common2 = require("./utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const prepareLengend = (params, legendSize) => {
  const legend = (0, _public2.buildExpressionFunction)('legendConfig', {
    isVisible: params.addLegend,
    maxLines: params.maxLegendLines,
    position: params.legendPosition,
    shouldTruncate: params.truncateLegend,
    showSingleSeries: true,
    legendSize
  });
  return (0, _public2.buildExpression)([legend]);
};
const getCorrectAccessor = (yAccessor, aggId) => {
  return typeof yAccessor.accessor === 'number' ? `col-${yAccessor.accessor}-${aggId}` : yAccessor.accessor;
};
const prepareDecoration = (axisId, yAccessor, aggId) => {
  const dataDecorationConfig = (0, _public2.buildExpressionFunction)('dataDecorationConfig', {
    forAccessor: getCorrectAccessor(yAccessor, aggId),
    axisId
  });
  return (0, _public2.buildExpression)([dataDecorationConfig]);
};
const preparePalette = palette => {
  const paletteExp = (0, _public2.buildExpressionFunction)(palette.name === 'custom' ? 'palette' : 'system_palette', palette.name === 'custom' ? {
    ...palette.params
  } : {
    name: palette.name
  });
  return (0, _public2.buildExpression)([paletteExp]);
};
const prepareLayers = (seriesParam, isHistogram, valueAxes, yAccessors, xAccessor, splitAccessors, markSizeAccessor, palette, xScale) => {
  var _seriesParam$circlesR, _xAccessor$format, _xAccessor$format2, _xAccessor$format2$pa, _xAccessor$format3, _xAccessor$format4;
  // valueAxis.position !== Position.Left
  const isHorizontal = valueAxes.some(valueAxis => {
    return seriesParam.valueAxis === valueAxis.id && valueAxis.position !== _charts.Position.Left && valueAxis.position !== _charts.Position.Right;
  });
  const isBar = seriesParam.type === _common.ChartType.Histogram;
  const dataLayer = (0, _public2.buildExpressionFunction)('extendedDataLayer', {
    seriesType: isBar ? 'bar' : seriesParam.type,
    isHistogram,
    isHorizontal,
    isStacked: seriesParam.mode === _types.ChartMode.Stacked,
    lineWidth: !isBar ? seriesParam.lineWidth : undefined,
    showPoints: !isBar ? seriesParam.showCircles : undefined,
    pointsRadius: !isBar ? (_seriesParam$circlesR = seriesParam.circlesRadius) !== null && _seriesParam$circlesR !== void 0 ? _seriesParam$circlesR : 3 : undefined,
    showLines: !isBar ? seriesParam.drawLinesBetweenPoints : undefined,
    curveType: (0, _common2.getCurveType)(seriesParam.interpolate),
    decorations: yAccessors.map(accessor => prepareDecoration(seriesParam.valueAxis, accessor, seriesParam.data.id)),
    accessors: yAccessors.map(accessor => prepareVisDimension(accessor)),
    xAccessor: xAccessor ? prepareVisDimension(xAccessor) : 'all',
    xScaleType: getScaleType(xScale, (xAccessor === null || xAccessor === void 0 ? void 0 : (_xAccessor$format = xAccessor.format) === null || _xAccessor$format === void 0 ? void 0 : _xAccessor$format.id) === 'number' || (xAccessor === null || xAccessor === void 0 ? void 0 : (_xAccessor$format2 = xAccessor.format) === null || _xAccessor$format2 === void 0 ? void 0 : (_xAccessor$format2$pa = _xAccessor$format2.params) === null || _xAccessor$format2$pa === void 0 ? void 0 : _xAccessor$format2$pa.id) === 'number' && (xAccessor === null || xAccessor === void 0 ? void 0 : (_xAccessor$format3 = xAccessor.format) === null || _xAccessor$format3 === void 0 ? void 0 : _xAccessor$format3.id) !== _public3.BUCKET_TYPES.RANGE && (xAccessor === null || xAccessor === void 0 ? void 0 : (_xAccessor$format4 = xAccessor.format) === null || _xAccessor$format4 === void 0 ? void 0 : _xAccessor$format4.id) !== _public3.BUCKET_TYPES.TERMS, 'date' in ((xAccessor === null || xAccessor === void 0 ? void 0 : xAccessor.params) || {}), 'interval' in ((xAccessor === null || xAccessor === void 0 ? void 0 : xAccessor.params) || {})),
    splitAccessors: splitAccessors ? splitAccessors.map(prepareVisDimension) : undefined,
    markSizeAccessor: markSizeAccessor && !isBar ? prepareVisDimension(markSizeAccessor) : undefined,
    palette: palette ? preparePalette(palette) : undefined,
    columnToLabel: JSON.stringify([...yAccessors, xAccessor, ...(splitAccessors !== null && splitAccessors !== void 0 ? splitAccessors : [])].reduce((acc, dimension) => {
      if (dimension) {
        acc[getCorrectAccessor(dimension, seriesParam.data.id)] = dimension.label;
      }
      return acc;
    }, {}))
  });
  return (0, _public2.buildExpression)([dataLayer]);
};
const getLabelArgs = (data, isTimeChart) => {
  var _data$labels$rotate;
  return {
    truncate: data.labels.truncate,
    labelsOrientation: -((_data$labels$rotate = data.labels.rotate) !== null && _data$labels$rotate !== void 0 ? _data$labels$rotate : isTimeChart ? 0 : 90),
    showOverlappingLabels: data.labels.filter === false,
    showDuplicates: data.labels.filter === false,
    labelColor: data.labels.color,
    showLabels: data.labels.show
  };
};
const prepareAxisExtentConfig = (scale, bounds) => {
  const axisExtentConfig = (0, _public2.buildExpressionFunction)('axisExtentConfig', {
    mode: (0, _common2.getMode)(scale, bounds),
    lowerBound: (bounds === null || bounds === void 0 ? void 0 : bounds.min) || scale.min,
    upperBound: (bounds === null || bounds === void 0 ? void 0 : bounds.max) || scale.max,
    enforce: true
  });
  return (0, _public2.buildExpression)([axisExtentConfig]);
};
function getScaleType(scale, isNumber, isTime = false, isHistogram = false) {
  if (isTime) return _charts.ScaleType.Time;
  if (isHistogram) return _charts.ScaleType.Linear;
  if (!isNumber) {
    return _charts.ScaleType.Ordinal;
  }
  const type = scale === null || scale === void 0 ? void 0 : scale.type;
  if (type === _types.ScaleType.SquareRoot) {
    return _charts.ScaleType.Sqrt;
  }
  return type;
}
function getXAxisPosition(position) {
  if (position === _charts.Position.Left) {
    return _charts.Position.Bottom;
  }
  if (position === _charts.Position.Right) {
    return _charts.Position.Top;
  }
  return position;
}
const prepareXAxis = (data, showGridLines, bounds, isTimeChart) => {
  const xAxisConfig = (0, _public2.buildExpressionFunction)('xAxisConfig', {
    hide: !data.show,
    position: getXAxisPosition(data.position),
    title: data.title.text,
    extent: prepareAxisExtentConfig(data.scale, bounds),
    showGridLines,
    ...getLabelArgs(data, isTimeChart)
  });
  return (0, _public2.buildExpression)([xAxisConfig]);
};
const prepareYAxis = (data, showGridLines) => {
  const yAxisConfig = (0, _public2.buildExpressionFunction)('yAxisConfig', {
    id: data.id,
    hide: !data.show,
    position: (0, _common2.getYAxisPosition)(data.position),
    title: data.title.text,
    extent: prepareAxisExtentConfig(data.scale),
    boundsMargin: data.scale.boundsMargin,
    scaleType: getScaleType(data.scale, true),
    mode: data.scale.mode,
    showGridLines,
    ...getLabelArgs(data)
  });
  return (0, _public2.buildExpression)([yAxisConfig]);
};
const prepareReferenceLine = (thresholdLine, axisId) => {
  const referenceLine = (0, _public2.buildExpressionFunction)('referenceLine', {
    value: thresholdLine.value,
    color: thresholdLine.color,
    lineWidth: thresholdLine.width,
    lineStyle: (0, _common2.getLineStyle)(thresholdLine.style),
    axisId
  });
  return (0, _public2.buildExpression)([referenceLine]);
};
const prepareVisDimension = data => {
  const visDimension = (0, _public2.buildExpressionFunction)('visdimension', {
    accessor: data.accessor
  });
  if (data.format) {
    visDimension.addArgument('format', data.format.id);
    visDimension.addArgument('formatParams', JSON.stringify(data.format.params));
  }
  return (0, _public2.buildExpression)([visDimension]);
};
const isDateHistogramParams = params => params.date;
exports.isDateHistogramParams = isDateHistogramParams;
const toExpressionAst = async (vis, params) => {
  var _vis$data$aggs$getRes, _vis$data$aggs, _vis$type$schemas, _dimensions$x, _dimensions$x$params, _dimensions$x2, _dimensions$x3, _dimensions$x4, _dimensions$x5, _dimensions$x6, _dimensions$x7, _dimensions$x8, _dimensions$x9, _dimensions$x10, _dimensions$x11, _dimensions$x12, _dimensions$splitColu, _dimensions$splitRow;
  const schemas = (0, _public.getVisSchemas)(vis, params);
  const dimensions = {
    x: schemas.segment ? schemas.segment[0] : null,
    y: schemas.metric,
    z: schemas.radius,
    width: schemas.width,
    series: schemas.group,
    splitRow: schemas.split_row,
    splitColumn: schemas.split_column
  };
  const responseAggs = (_vis$data$aggs$getRes = (_vis$data$aggs = vis.data.aggs) === null || _vis$data$aggs === void 0 ? void 0 : _vis$data$aggs.getResponseAggs().filter(({
    enabled
  }) => enabled)) !== null && _vis$data$aggs$getRes !== void 0 ? _vis$data$aggs$getRes : [];
  const schemaName = (_vis$type$schemas = vis.type.schemas) === null || _vis$type$schemas === void 0 ? void 0 : _vis$type$schemas.metrics[0].name;
  const firstValueAxesId = vis.params.valueAxes[0].id;
  const updatedSeries = (0, _get_series_params.getSeriesParams)(vis.data.aggs, vis.params.seriesParams, schemaName, firstValueAxesId);
  const finalSeriesParams = updatedSeries !== null && updatedSeries !== void 0 ? updatedSeries : vis.params.seriesParams;
  let isHistogram = false;
  if (dimensions.x) {
    const xAgg = responseAggs[dimensions.x.accessor];
    if (xAgg.type.name === _public3.BUCKET_TYPES.DATE_HISTOGRAM) {
      isHistogram = true;
      dimensions.x.params.date = true;
      const {
        esUnit,
        esValue
      } = xAgg.buckets.getInterval();
      dimensions.x.params.intervalESUnit = esUnit;
      dimensions.x.params.intervalESValue = esValue;
      dimensions.x.params.interval = _moment.default.duration(esValue, esUnit).asMilliseconds();
      dimensions.x.params.format = xAgg.buckets.getScaledDateFormat();
      const bounds = xAgg.buckets.getBounds();
      if (bounds && bounds !== null && bounds !== void 0 && bounds.min && bounds !== null && bounds !== void 0 && bounds.max) {
        dimensions.x.params.bounds = {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        };
      }
    } else if (xAgg.type.name === _public3.BUCKET_TYPES.HISTOGRAM) {
      isHistogram = true;
      const intervalParam = xAgg.type.paramByName('interval');
      const output = {
        params: {}
      };
      await intervalParam.modifyAggConfigOnSearchRequestStart(xAgg, vis.data.searchSource, {
        abortSignal: params.abortSignal
      });
      intervalParam.write(xAgg, output);
      dimensions.x.params.interval = output.params.interval;
    }
  }
  (dimensions.y || []).forEach(yDimension => {
    const yAgg = responseAggs[yDimension.accessor];
    const aggId = (0, _accessors.getSafeId)(yAgg.id);
    const seriesParam = (vis.params.seriesParams || []).find(param => param.data.id === aggId);
    if (seriesParam) {
      const usedValueAxis = (vis.params.valueAxes || []).find(valueAxis => valueAxis.id === seriesParam.valueAxis);
      if ((usedValueAxis === null || usedValueAxis === void 0 ? void 0 : usedValueAxis.scale.mode) === 'percentage') {
        yDimension.format = {
          id: 'percent'
        };
      }
    }
  });
  let legendSize = vis.params.legendSize;
  if (vis.params.legendPosition === _charts.Position.Top || vis.params.legendPosition === _charts.Position.Bottom) {
    legendSize = _public.LegendSize.AUTO;
  }
  const yAccessors = (dimensions.y || []).reduce((acc, yDimension) => {
    const yAgg = responseAggs[yDimension.accessor];
    const aggId = (0, _accessors.getSafeId)(yAgg.id);
    const dimension = {
      ...yDimension,
      accessor: getCorrectAccessor(yDimension, yAgg.id)
    };
    if (acc[aggId]) {
      acc[aggId].push(dimension);
    } else {
      acc[aggId] = [dimension];
    }
    return acc;
  }, {});
  const xScale = vis.params.categoryAxes[0].scale;
  let mapColumn;
  if (!dimensions.x) {
    mapColumn = (0, _public2.buildExpressionFunction)('mapColumn', {
      id: 'all',
      expression: '_all',
      name: _i18n.i18n.translate('visTypeXy.allDocsTitle', {
        defaultMessage: 'All docs'
      })
    });
  }
  const visibleSeries = finalSeriesParams.filter(param => param.show && yAccessors[param.data.id]);
  const visTypeXy = (0, _public2.buildExpressionFunction)('layeredXyVis', {
    layers: [...visibleSeries.map(seriesParams => prepareLayers(seriesParams, isHistogram, vis.params.valueAxes, yAccessors[seriesParams.data.id], dimensions.x, dimensions.series, dimensions.z ? dimensions.z[0] : undefined, vis.params.palette, xScale)), ...(vis.params.thresholdLine.show ? [prepareReferenceLine(vis.params.thresholdLine, vis.params.valueAxes[0].id)] : [])],
    addTimeMarker: vis.params.addTimeMarker && ((_dimensions$x = dimensions.x) === null || _dimensions$x === void 0 ? void 0 : (_dimensions$x$params = _dimensions$x.params) === null || _dimensions$x$params === void 0 ? void 0 : _dimensions$x$params.date),
    orderBucketsBySum: vis.params.orderBucketsBySum,
    fittingFunction: vis.params.fittingFunction ? vis.params.fittingFunction.charAt(0).toUpperCase() + vis.params.fittingFunction.slice(1) : undefined,
    detailedTooltip: vis.params.detailedTooltip,
    fillOpacity: vis.params.fillOpacity,
    showTooltip: vis.params.addTooltip,
    markSizeRatio: dimensions.z && visibleSeries.some(param => param.type === _common.ChartType.Area || param.type === _common.ChartType.Line) ? vis.params.radiusRatio * 0.6 // NOTE: downscale ratio to match current vislib implementation
    : undefined,
    legend: prepareLengend(vis.params, legendSize),
    xAxisConfig: prepareXAxis(vis.params.categoryAxes[0], vis.params.grid.categoryLines, (_dimensions$x2 = dimensions.x) !== null && _dimensions$x2 !== void 0 && _dimensions$x2.params && isDateHistogramParams((_dimensions$x3 = dimensions.x) === null || _dimensions$x3 === void 0 ? void 0 : _dimensions$x3.params) ? (_dimensions$x4 = dimensions.x) === null || _dimensions$x4 === void 0 ? void 0 : _dimensions$x4.params.bounds : undefined, (_dimensions$x5 = dimensions.x) !== null && _dimensions$x5 !== void 0 && _dimensions$x5.params && isDateHistogramParams((_dimensions$x6 = dimensions.x) === null || _dimensions$x6 === void 0 ? void 0 : _dimensions$x6.params) ? (_dimensions$x7 = dimensions.x) === null || _dimensions$x7 === void 0 ? void 0 : _dimensions$x7.params.date : undefined),
    // as we have only one x axis
    yAxisConfigs: vis.params.valueAxes.filter(axis => visibleSeries.some(seriesParam => seriesParam.valueAxis === axis.id)).map(valueAxis => prepareYAxis(valueAxis, vis.params.grid.valueAxis === valueAxis.id)),
    minTimeBarInterval: (_dimensions$x8 = dimensions.x) !== null && _dimensions$x8 !== void 0 && _dimensions$x8.params && isDateHistogramParams((_dimensions$x9 = dimensions.x) === null || _dimensions$x9 === void 0 ? void 0 : _dimensions$x9.params) && (_dimensions$x10 = dimensions.x) !== null && _dimensions$x10 !== void 0 && _dimensions$x10.params.date && visibleSeries.some(param => param.type === _common.ChartType.Histogram) ? ((_dimensions$x11 = dimensions.x) === null || _dimensions$x11 === void 0 ? void 0 : _dimensions$x11.params.intervalESValue) + ((_dimensions$x12 = dimensions.x) === null || _dimensions$x12 === void 0 ? void 0 : _dimensions$x12.params.intervalESUnit) : undefined,
    splitColumnAccessor: (_dimensions$splitColu = dimensions.splitColumn) === null || _dimensions$splitColu === void 0 ? void 0 : _dimensions$splitColu.map(prepareVisDimension),
    splitRowAccessor: (_dimensions$splitRow = dimensions.splitRow) === null || _dimensions$splitRow === void 0 ? void 0 : _dimensions$splitRow.map(prepareVisDimension),
    valueLabels: vis.params.labels.show ? 'show' : 'hide',
    valuesInLegend: vis.params.labels.show,
    singleTable: true
  });
  const ast = (0, _public2.buildExpression)(mapColumn ? [mapColumn, visTypeXy] : [visTypeXy]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;