"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PointSeriesOptions = PointSeriesOptions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _grid_panel = require("./grid_panel");
var _threshold_panel = require("./threshold_panel");
var _common = require("../../../../../common");
var _elastic_charts_options = require("./elastic_charts_options");
var _collections = require("../../../collections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const legendPositions = (0, _collections.getPositions)();
function PointSeriesOptions(props) {
  var _stateParams$truncate, _stateParams$maxLegen, _vis$data, _vis$data$aggs;
  const {
    stateParams,
    setValue,
    vis,
    aggs
  } = props;
  const hasBarChart = (0, _react.useMemo)(() => stateParams.seriesParams.some(({
    type,
    data: {
      id: paramId
    }
  }) => {
    var _aggs$aggs$find;
    return type === _common.ChartType.Histogram && (aggs === null || aggs === void 0 ? void 0 : (_aggs$aggs$find = aggs.aggs.find(({
      id
    }) => id === paramId)) === null || _aggs$aggs$find === void 0 ? void 0 : _aggs$aggs$find.enabled);
  }), [stateParams.seriesParams, aggs === null || aggs === void 0 ? void 0 : aggs.aggs]);
  const legendSize = stateParams.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public3.LegendSize.AUTO);
  const handleLegendSizeChange = (0, _react.useCallback)(size => setValue('legendSize', size), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.editors.pointSeries.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.BasicOptions, (0, _extends2.default)({}, props, {
    legendPositions: legendPositions
  })), /*#__PURE__*/_react.default.createElement(_public.LongLegendOptions, {
    "data-test-subj": "xyLongLegendsOptions",
    truncateLegend: (_stateParams$truncate = stateParams.truncateLegend) !== null && _stateParams$truncate !== void 0 ? _stateParams$truncate : true,
    maxLegendLines: (_stateParams$maxLegen = stateParams.maxLegendLines) !== null && _stateParams$maxLegen !== void 0 ? _stateParams$maxLegen : 1,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public.LegendSizeSettings, {
    legendSize: legendSize,
    onLegendSizeChange: handleLegendSizeChange,
    isVerticalLegend: stateParams.legendPosition === _charts.Position.Left || stateParams.legendPosition === _charts.Position.Right,
    showAutoOption: hadAutoLegendSize
  }), (_vis$data = vis.data) !== null && _vis$data !== void 0 && (_vis$data$aggs = _vis$data.aggs) !== null && _vis$data$aggs !== void 0 && _vis$data$aggs.aggs.some(agg => agg.schema === 'segment' && agg.type.name === _public2.BUCKET_TYPES.DATE_HISTOGRAM) ? /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "addTimeMarker",
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.currentTimeMarkerLabel', {
      defaultMessage: 'Current time marker'
    }),
    paramName: "addTimeMarker",
    value: stateParams.addTimeMarker,
    setValue: setValue
  }) : /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "orderBucketsBySum",
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.orderBucketsBySumLabel', {
      defaultMessage: 'Order buckets by sum'
    }),
    paramName: "orderBucketsBySum",
    value: stateParams.orderBucketsBySum,
    setValue: setValue
  }), hasBarChart && /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "showValuesOnChart",
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.showLabels', {
      defaultMessage: 'Show values on chart'
    }),
    paramName: "show",
    value: stateParams.labels.show,
    setValue: (paramName, value) => setValue('labels', {
      ...stateParams.labels,
      [paramName]: value
    })
  }), /*#__PURE__*/_react.default.createElement(_elastic_charts_options.ElasticChartsOptions, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_grid_panel.GridPanel, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), stateParams.thresholdLine && /*#__PURE__*/_react.default.createElement(_threshold_panel.ThresholdPanel, props));
}