"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVis = getVis;
var _lodash = _interopRequireDefault(require("lodash"));
var _jquery = _interopRequireDefault(require("jquery"));
var _mocks = require("@kbn/core/public/mocks");
var _mocks2 = require("@kbn/charts-plugin/public/mocks");
var _vis = require("../vis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const $visCanvas = (0, _jquery.default)('<div>').attr('id', 'vislib-vis-fixtures').css({
  height: '500px',
  width: '1024px',
  display: 'flex',
  position: 'fixed',
  top: '0px',
  left: '0px',
  overflow: 'hidden',
  'pointer-events': 'none' // Prevent element from blocking you from clicking a test
}).appendTo('body');
let count = 0;
const visHeight = $visCanvas.height();
$visCanvas.new = function () {
  count += 1;
  if (count > 1) $visCanvas.height(visHeight * count);
  return (0, _jquery.default)('<div>').addClass('visChart').appendTo($visCanvas);
};
afterEach(function () {
  $visCanvas.empty();
  if (count > 1) $visCanvas.height(visHeight);
  count = 0;
});
function getVis(vislibParams, element) {
  return new _vis.Vis(element || $visCanvas.new(), _lodash.default.defaults({}, vislibParams || {}, {
    addTooltip: true,
    addLegend: true,
    defaultYExtents: false,
    setYExtents: false,
    yAxis: {},
    type: 'heatmap'
  }), _mocks.coreMock.createSetup(), _mocks2.chartPluginMock.createStartContract());
}