"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yAxisSplit = yAxisSplit;
var _d = _interopRequireDefault(require("d3"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Adds div DOM elements to the `.visAxis__splitAxes--y` element based on the data layout.
 * For example, if the data has rows, it returns the same number of
 * `.y-axis-div` elements as row objects.
 */

// render and get bounding box width
function yAxisSplit(selection) {
  selection.each(function () {
    const div = _d.default.select(this);
    let rows;
    div.selectAll('.y-axis-div').append('div').data(function (d) {
      rows = d.rows ? d.rows.length : 1;
      return d.rows ? d.rows : [d];
    }).enter().append('div').attr('class', (d, i) => {
      let divClass = '';
      if (i === 0) {
        divClass += ' visWrapper__chart--first';
      }
      if (i === rows - 1) {
        divClass += ' visWrapper__chart--last';
      }
      return 'y-axis-div axis-div' + divClass;
    });
  });
}