"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AxisTitle = void 0;
var _d = _interopRequireDefault(require("d3"));
var _jquery = _interopRequireDefault(require("jquery"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class AxisTitle {
  constructor(axisConfig) {
    this.axisConfig = axisConfig;
    this.elSelector = this.axisConfig.get('title.elSelector').replace('{pos}', this.axisConfig.get('position'));
  }
  render() {
    _d.default.select(this.axisConfig.get('rootEl')).selectAll(this.elSelector).call(this.draw());
  }
  destroy() {
    (0, _jquery.default)(this.axisConfig.get('rootEl')).find(this.elSelector).find('svg').remove();
  }
  draw() {
    const config = this.axisConfig;
    return function (selection) {
      selection.each(function () {
        if (!config.get('show') && !config.get('title.show', false)) return;
        const el = this;
        const div = _d.default.select(el);
        const width = (0, _jquery.default)(el).width();
        const height = (0, _jquery.default)(el).height();
        const axisPrefix = config.isHorizontal() ? 'x' : 'y';
        const svg = div.append('svg').attr('focusable', 'false').attr('width', width).attr('height', height).attr('class', `axis-title ${axisPrefix}-axis-title`);
        const bbox = svg.append('text').attr('transform', function () {
          if (config.isHorizontal()) {
            return `translate(${width / 2},0)`;
          }
          return `translate(0,${height / 2}) rotate(270)`;
        }).attr('text-anchor', 'middle').attr('dominant-baseline', 'hanging').text(config.get('title.text')).node().getBBox();
        if (config.isHorizontal()) {
          svg.attr('height', Math.ceil(bbox.height));
        } else {
          svg.attr('width', Math.ceil(bbox.height));
        }
      });
    };
  }
}
exports.AxisTitle = AxisTitle;