"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeries = getSeries;
var _lodash = require("lodash");
var _get_point = require("./_get_point");
var _add_to_siri = require("./_add_to_siri");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSeries(table, chart) {
  const aspects = chart.aspects;
  const xAspect = aspects.x[0];
  const yAspect = aspects.y[0];
  const zAspect = aspects.z && aspects.z[0];
  const multiY = Array.isArray(aspects.y) && aspects.y.length > 1;
  const partGetPoint = (0, _lodash.partial)(_get_point.getPoint, table, xAspect, aspects.series);
  const seriesMap = new Map();
  table.rows.forEach((row, rowIndex) => {
    if (!multiY) {
      const point = partGetPoint(row, rowIndex, yAspect, zAspect);
      if (point) {
        const id = `${point.series}-${yAspect.accessor}`;
        point.seriesId = id;
        (0, _add_to_siri.addToSiri)(seriesMap, point, id, point.series, yAspect.format, zAspect && zAspect.format, zAspect && zAspect.title);
      }
      return;
    }
    aspects.y.forEach(function (y) {
      const point = partGetPoint(row, rowIndex, y, zAspect);
      if (!point) {
        return;
      }

      // use the point's y-axis as it's series by default,
      // but augment that with series aspect if it's actually
      // available
      let seriesId = y.accessor;
      let seriesLabel = y.title;
      if (aspects.series) {
        const prefix = point.series ? point.series + ': ' : '';
        seriesId = prefix + seriesId;
        seriesLabel = prefix + seriesLabel;
      }
      point.seriesId = seriesId;
      (0, _add_to_siri.addToSiri)(seriesMap, point, seriesId, seriesLabel, y.format, zAspect && zAspect.format, zAspect && zAspect.title);
    });
  });
  return [...seriesMap.values()];
}