"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hierarchicalTooltipFormatter = hierarchicalTooltipFormatter;
var _react = _interopRequireDefault(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _server = require("react-dom/server");
var _i18nReact = require("@kbn/i18n-react");
var _collect_branch = require("./_collect_branch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function hierarchicalTooltipFormatter(metricFieldFormatter) {
  return function ({
    datum
  }) {
    // Collect the current leaf and parents into an array of values
    const rows = (0, _collect_branch.collectBranch)(datum);

    // Map those values to what the tooltipSource.rows format.
    _lodash.default.forEachRight(rows, function (row) {
      row.spacer = _lodash.default.escape(_lodash.default.repeat('&nbsp;', row.depth));
      let percent;
      if (row.item.percentOfGroup !== null && row.item.percentOfGroup !== undefined) {
        percent = row.item.percentOfGroup;
      }
      row.metric = metricFieldFormatter ? metricFieldFormatter.convert(row.metric) : row.metric;
      if (percent !== null && percent !== undefined) {
        row.metric += ' (' + (0, _numeral.default)(percent).format('0.[00]%') + ')';
      }
      return row;
    });
    return (0, _server.renderToStaticMarkup)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement("table", {
      className: "visTooltip__table"
    }, /*#__PURE__*/_react.default.createElement("thead", null, /*#__PURE__*/_react.default.createElement("tr", {
      className: "eui-textLeft visTooltip__label"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "th",
      scope: "col",
      id: "visTypeVislib.vislib.tooltip.fieldLabel",
      defaultMessage: "field"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "th",
      scope: "col",
      id: "visTypeVislib.vislib.tooltip.valueLabel",
      defaultMessage: "value"
    }), /*#__PURE__*/_react.default.createElement("th", {
      scope: "col"
    }))), /*#__PURE__*/_react.default.createElement("tbody", null, rows.map((row, index) => /*#__PURE__*/_react.default.createElement("tr", {
      className: "visTooltip__value",
      key: index
    }, /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "visTooltip__labelContainer"
    }, /*#__PURE__*/_react.default.createElement("span", {
      "ng-bind-html": "row.spacer"
    }), row.field)), /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "visTooltip__labelContainer"
    }, row.bucket)), /*#__PURE__*/_react.default.createElement("td", null, row.metric)))))));
  };
}