"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _analytics = require("@kbn/analytics");
var _vis_controller = require("./vis_controller");
require("./index.scss");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const VislibWrapper = ({
  core,
  charts,
  visData,
  visConfig,
  handlers
}) => {
  const chartDiv = (0, _react.useRef)(null);
  const visController = (0, _react.useRef)(null);
  const skipRenderComplete = (0, _react.useRef)(true);
  const renderComplete = (0, _react.useMemo)(() => () => {
    const usageCollection = (0, _services.getUsageCollectionStart)();
    const containerType = extractContainerType(handlers.getExecutionContext());
    if (usageCollection && containerType) {
      usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, `render_agg_based_${visConfig.type}`);
    }
    handlers.done();
  }, [handlers, visConfig]);
  const renderChart = (0, _react.useMemo)(() => (0, _lodash.debounce)(() => {
    if (visController.current) {
      visController.current.render(visData, visConfig, handlers, skipRenderComplete.current ? undefined : renderComplete);
    }
    skipRenderComplete.current = true;
  }, 100), [handlers, renderComplete, skipRenderComplete, visConfig, visData]);
  const onResize = (0, _react.useCallback)(() => {
    renderChart();
  }, [renderChart]);
  (0, _react.useEffect)(() => {
    skipRenderComplete.current = false;
    renderChart();
  }, [renderChart]);
  (0, _react.useEffect)(() => {
    if (chartDiv.current) {
      const Controller = (0, _vis_controller.createVislibVisController)(core, charts);
      visController.current = new Controller(chartDiv.current);
    }
    return () => {
      var _visController$curren;
      (_visController$curren = visController.current) === null || _visController$curren === void 0 ? void 0 : _visController$curren.destroy();
      visController.current = null;
    };
  }, [core, charts]);
  (0, _react.useEffect)(() => {
    if (handlers.uiState) {
      const uiState = handlers.uiState;
      uiState.on('change', renderChart);
      return () => {
        uiState === null || uiState === void 0 ? void 0 : uiState.off('change', renderChart);
      };
    }
  }, [handlers.uiState, renderChart]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    className: "vislib__wrapper",
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "vislib__container",
    ref: chartDiv
  })));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = VislibWrapper;
module.exports = exports.default;