"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vegaVisTooltipStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _tool_tip = require("@elastic/eui/lib/components/tool_tip/tool_tip.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-expect-error style types not defined

// Style tooltip popup (gets created dynamically at the top level if dashboard has a Vega vis)
// Adapted from https://github.com/vega/vega-tooltip

const vegaVisTooltipStyles = euiThemeContext => {
  const {
    euiTheme
  } = euiThemeContext;
  // Merge EUI tooltip styles into ours
  const euiStyles = (0, _tool_tip.euiToolTipStyles)(euiThemeContext);

  // Note that these are globally-set styles, due to vega_tooltip being vanilla JS/non-React
  return (0, _react.css)`
    .vgaVis__tooltip {
      ${euiStyles.euiToolTip}

      ${(0, _eui.logicalCSS)('max-width', '100%')}
        position: fixed;

      h2 {
        ${(0, _eui.logicalCSS)('margin-bottom', euiTheme.size.s)}
      }

      &--textTruncate {
        td {
          ${(0, _eui.euiTextTruncate)()}
        }
      }

      td {
        ${(0, _eui.logicalCSS)('padding-vertical', euiTheme.size.xs)}

        &.key {
          ${(0, _eui.logicalCSS)('max-width', (0, _eui.mathWithUnits)(euiTheme.size.base, x => x * 10))}
          color: ${euiTheme.colors.mediumShade};
          ${(0, _eui.logicalTextAlignCSS)('right')}
          ${(0, _eui.logicalCSS)('padding-right', euiTheme.size.xs)}
        }

        &.value {
          ${(0, _eui.logicalCSS)('max-width', (0, _eui.mathWithUnits)(euiTheme.size.l, x => x * 10))}
          ${(0, _eui.logicalTextAlignCSS)('left')}
        }
      }

      ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 'm'])} {
        td {
          &.key {
            ${(0, _eui.logicalCSS)('max-width', (0, _eui.mathWithUnits)(euiTheme.size.base, x => x * 6))}
          }

          &.value {
            ${(0, _eui.logicalCSS)('max-width', (0, _eui.mathWithUnits)(euiTheme.size.base, x => x * 10))}
          }
        }
      }
    }

    // Positions
    .vgaVis__tooltip--left {
      ${euiStyles.left}
    }
    .vgaVis__tooltip--right {
      ${euiStyles.right}
    }
    .vgaVis__tooltip--top {
      ${euiStyles.top}
    }
    .vgaVis__tooltip--bottom {
      ${euiStyles.bottom}
    }
  `;
};
exports.vegaVisTooltipStyles = vegaVisTooltipStyles;