"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaStateRestorer = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createVegaStateRestorer = ({
  omitSignals = ['width', 'height', 'padding', 'autosize', 'background'],
  isActive = () => true
} = {}) => {
  let state;
  return {
    /**
     * Save Vega state
     * @public
     * @param newState - new state value
     */
    save: newState => {
      if (newState && isActive()) {
        state = {
          signals: (0, _lodash.omit)(newState.signals, omitSignals || []),
          data: newState.data
        };
      }
    },
    /**
     * Restore Vega state
     * @public
     * @param restoreData - by default, we only recover signals,
     *        but if the data also needs to be recovered, this option should be set to true
     */
    restore: (restoreData = false) => isActive() && state ? (0, _lodash.omit)(state, restoreData ? undefined : 'data') : null,
    /**
     *  Clear saved Vega state
     *
     *  @public
     */
    clear: () => {
      state = null;
    }
  };
};
exports.createVegaStateRestorer = createVegaStateRestorer;