"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractIndexPatternsFromSpec = void 0;
var _lodash = require("lodash");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const extractIndexPatternsFromSpec = async spec => {
  const dataViews = (0, _services.getDataViews)();
  let data = [];
  if (Array.isArray(spec.data)) {
    data = spec.data;
  } else if (spec.data) {
    data = [spec.data];
  }
  return (0, _lodash.flatten)(await Promise.all(data.reduce((accumulator, currentValue) => {
    var _currentValue$url;
    if ((_currentValue$url = currentValue.url) !== null && _currentValue$url !== void 0 && _currentValue$url.index) {
      accumulator.push(dataViews.find(currentValue.url.index, 1));
    }
    return accumulator;
  }, [])));
};
exports.extractIndexPatternsFromSpec = extractIndexPatternsFromSpec;