"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = VegaVisEditor;
var _monaco = require("@kbn/monaco");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _hjson = _interopRequireDefault(require("hjson"));
var _react = _interopRequireWildcard(require("react"));
var _jsonStringifyPrettyCompact = _interopRequireDefault(require("json-stringify-pretty-compact"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
var _vega_help_menu = require("./vega_help_menu");
var _vega_actions_menu = require("./vega_actions_menu");
require("./vega_editor.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function format(value, stringify, options) {
  try {
    const spec = _hjson.default.parse(value, {
      legacyRoot: false,
      keepWsc: true
    });
    return {
      value: stringify(spec, options),
      isValid: true
    };
  } catch (err) {
    // This is a common case - user tries to format an invalid HJSON text
    (0, _services.getNotifications)().toasts.addError(err, {
      title: _i18n.i18n.translate('visTypeVega.editor.formatError', {
        defaultMessage: 'Error formatting spec'
      })
    });
    return {
      value,
      isValid: false
    };
  }
}
function VegaVisEditor({
  stateParams,
  setValue
}) {
  const [languageId, setLanguageId] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    let specLang = _monaco.XJsonLang.ID;
    try {
      JSON.parse(stateParams.spec);
    } catch {
      specLang = _public.HJsonLang;
    }
    setLanguageId(specLang);
  });
  const setSpec = (0, _react.useCallback)((value, specLang) => {
    setValue('spec', value);
    if (specLang) {
      setLanguageId(specLang);
    }
  }, [setValue]);
  const onChange = (0, _react.useCallback)(value => setSpec(value), [setSpec]);
  const formatJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _jsonStringifyPrettyCompact.default);
    if (isValid) {
      setSpec(value, _monaco.XJsonLang.ID);
    }
  }, [setSpec, stateParams.spec]);
  const formatHJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _hjson.default.stringify, {
      bracesSameLine: true,
      keepWsc: true
    });
    if (isValid) {
      setSpec(value, _public.HJsonLang);
    }
  }, [setSpec, stateParams.spec]);
  if (!languageId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor",
    "data-test-subj": "vega-editor"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor__editorActions"
  }, /*#__PURE__*/_react.default.createElement(_vega_help_menu.VegaHelpMenu, null), /*#__PURE__*/_react.default.createElement(_vega_actions_menu.VegaActionsMenu, {
    formatHJson: formatHJson,
    formatJson: formatJson
  })), /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    width: "100%",
    height: "100%",
    languageId: languageId,
    value: stateParams.spec,
    onChange: onChange,
    options: {
      lineNumbers: 'on',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;