"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaActionsMenu = VegaActionsMenu;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function VegaActionsMenu({
  formatHJson,
  formatJson
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const onHJsonCLick = (0, _react.useCallback)(() => {
    formatHJson();
    setIsPopoverOpen(false);
  }, [formatHJson]);
  const onJsonCLick = (0, _react.useCallback)(() => {
    formatJson();
    setIsPopoverOpen(false);
  }, [formatJson]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "wrench",
    onClick: onButtonClick,
    "aria-label": _i18n.i18n.translate('visTypeVega.editor.vegaEditorOptionsButtonAriaLabel', {
      defaultMessage: 'Vega editor options'
    })
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "hjson",
    onClick: onHJsonCLick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.editor.reformatAsHJSONButtonLabel",
    defaultMessage: "Reformat as HJSON"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "json",
    onClick: onJsonCLick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.editor.reformatAsJSONButtonLabel",
    defaultMessage: "Reformat as JSON, delete comments"
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "actionsMenu",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  }));
}