"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_RESTRICTIONS = exports.SERIES = exports.PANEL = exports.METRIC = exports.INDEX_PATTERN = exports.FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UI_RESTRICTIONS = {
  '*': true
};
exports.UI_RESTRICTIONS = UI_RESTRICTIONS;
const INDEX_PATTERN = 'some-pattern';
exports.INDEX_PATTERN = INDEX_PATTERN;
const FIELDS = {
  [INDEX_PATTERN]: [{
    type: 'date',
    name: '@timestamp'
  }, {
    type: 'number',
    name: 'system.cpu.user.pct'
  }, {
    type: 'histogram',
    name: 'histogram_value'
  }]
};
exports.FIELDS = FIELDS;
const METRIC = {
  id: 'sample_metric',
  type: 'avg',
  field: 'system.cpu.user.pct'
};
exports.METRIC = METRIC;
const SERIES = {
  metrics: [METRIC]
};
exports.SERIES = SERIES;
const PANEL = {
  type: 'timeseries',
  index_pattern: INDEX_PATTERN,
  series: [SERIES]
};
exports.PANEL = PANEL;