"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _editor_controller = require("./application/editor_controller");
var _metrics_fn = require("./metrics_fn");
var _metrics_type = require("./metrics_type");
var _services = require("./services");
var _timeseries_vis_renderer = require("./timeseries_vis_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class MetricsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations
  }) {
    visualizations.visEditorsRegistry.register(_editor_controller.TSVB_EDITOR_NAME, _editor_controller.EditorController);
    expressions.registerFunction(_metrics_fn.createMetricsFn);
    expressions.registerRenderer((0, _timeseries_vis_renderer.getTimeseriesVisRenderer)({
      uiSettings: core.uiSettings,
      theme: core.theme
    }));
    (0, _services.setUISettings)(core.uiSettings);
    visualizations.createBaseVisualization(_metrics_type.metricsVisDefinition);
  }
  start(core, {
    data,
    charts,
    dataViews,
    usageCollection,
    fieldFormats,
    unifiedSearch
  }) {
    (0, _services.setCharts)(charts);
    (0, _services.setI18n)(core.i18n);
    (0, _services.setFieldFormats)(fieldFormats);
    (0, _services.setDataStart)(data);
    (0, _services.setUnifiedSearchStart)(unifiedSearch);
    (0, _services.setDataViewsStart)(dataViews);
    (0, _services.setCoreStart)(core);
    (0, _services.setUsageCollectionStart)(usageCollection);
  }
}
exports.MetricsPlugin = MetricsPlugin;