"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeriesAgg = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const functionMap = {
  mean: 'avg',
  min: 'min',
  max: 'max',
  sum: 'sum'
};
const getSeriesAgg = metrics => {
  const lastMetric = metrics[metrics.length - 1];
  if (lastMetric.type === 'series_agg' && lastMetric.function && functionMap[lastMetric.function]) {
    return {
      metrics: metrics.slice(0, -1),
      seriesAgg: functionMap[lastMetric.function]
    };
  } else {
    return {
      metrics,
      seriesAgg: undefined
    };
  }
};
exports.getSeriesAgg = getSeriesAgg;