"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertVarianceToFormulaColumn = void 0;
var _metrics = require("../metrics");
var _formula = require("./formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertVarianceToFormulaColumn = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  const metric = metrics[metrics.length - 1];
  const field = metric.field ? dataView.getFieldByName(metric.field) : undefined;
  if (!field) {
    return null;
  }
  const script = (0, _metrics.getFormulaEquivalent)(metric, metrics, {
    reducedTimeRange,
    timeShift: series.offset_time
  });
  if (!script) return null;
  return (0, _formula.createFormulaColumn)(script, {
    series,
    metric,
    dataView
  });
};
exports.convertVarianceToFormulaColumn = convertVarianceToFormulaColumn;