"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertTSVBtoLensConfiguration = void 0;
var _enums = require("../../common/enums");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getConvertFnByType = type => {
  var _convertionFns$type;
  const convertionFns = {
    [_enums.PANEL_TYPES.TIMESERIES]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./timeseries')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.TOP_N]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./top_n')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.METRIC]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./metric')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.GAUGE]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./gauge')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.TABLE]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./table')));
      return convertToLens;
    }
  };
  return (_convertionFns$type = convertionFns[type]) === null || _convertionFns$type === void 0 ? void 0 : _convertionFns$type.call(convertionFns);
};

/*
 * This function is used to convert the TSVB model to compatible Lens model.
 * Returns the Lens model, only if it is supported. If not, it returns null.
 * In case of null, the menu item is disabled and the user can't navigate to Lens.
 */
const convertTSVBtoLensConfiguration = async (vis, timeRange) => {
  var _await$convertFn;
  // Disables if model is invalid
  if (vis.params.isModelInvalid) {
    return null;
  }
  const convertFn = await getConvertFnByType(vis.params.type);
  return (_await$convertFn = await (convertFn === null || convertFn === void 0 ? void 0 : convertFn(vis, timeRange))) !== null && _await$convertFn !== void 0 ? _await$convertFn : null;
};
exports.convertTSVBtoLensConfiguration = convertTSVBtoLensConfiguration;