"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsEntities = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Chart = {
  seriesId: _propTypes.default.string.isRequired,
  seriesGroupId: _propTypes.default.string.isRequired,
  name: _propTypes.default.string.isRequired,
  /**
   * @example
   * [[1556917200000, 6], [1556231200000, 16]]
   */
  data: _propTypes.default.arrayOf(_propTypes.default.arrayOf(_propTypes.default.number)).isRequired,
  hideInLegend: _propTypes.default.bool.isRequired,
  color: _propTypes.default.string.isRequired,
  stackMode: _propTypes.default.oneOf(['percentage', 'wiggle', 'silhouette']),
  stackAccessors: _propTypes.default.arrayOf(_propTypes.default.number),
  xScaleType: _propTypes.default.string,
  yScaleType: _propTypes.default.string,
  timeZone: _propTypes.default.string.isRequired,
  enableHistogramMode: _propTypes.default.bool.isRequired,
  sortIndex: _propTypes.default.number
};
const BarChart = {
  ...Chart,
  bars: _propTypes.default.shape({
    fill: _propTypes.default.number,
    lineWidth: _propTypes.default.number,
    show: _propTypes.default.boolean
  }).isRequired
};
const AreaChart = {
  ...Chart,
  lines: _propTypes.default.shape({
    fill: _propTypes.default.number,
    lineWidth: _propTypes.default.number,
    show: _propTypes.default.bool,
    steps: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.bool])
  }).isRequired,
  points: _propTypes.default.shape({
    lineWidth: _propTypes.default.number,
    radius: _propTypes.default.number,
    show: _propTypes.default.bool
  }).isRequired
};
const ChartsEntities = {
  BarChart,
  AreaChart
};
exports.ChartsEntities = ChartsEntities;