"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metric = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _last_value_utils = require("../../../../common/last_value_utils");
var _calculate_coordinates = require("../lib/calculate_coordinates");
var _render_counter = require("../../components/render_counter");
require("./_metric.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Metric extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      scale: 1,
      left: 0,
      top: 0,
      translateX: 1,
      translateY: 1,
      resized: false
    };
    this.handleResize = this.handleResize.bind(this);
    this.checkResizeThrottled = _lodash.default.throttle(() => {
      const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
      if (newState && this.state && !_lodash.default.isEqual(newState, this.state)) {
        this.handleResize();
      }
    }, 200);
  }
  componentWillUnmount() {
    clearTimeout(this.timeout);
  }
  componentDidMount() {
    this.handleResize();
  }
  handleResize() {
    // Bingo!
    this.setState({
      ...(0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state),
      resized: true
    });
  }
  render() {
    const {
      metric,
      secondary,
      initialRender
    } = this.props;
    const {
      scale,
      translateX,
      translateY,
      resized
    } = this.state;
    const primaryFormatter = metric && (metric.tickFormatter || metric.formatter) || (n => n);
    const primaryValue = primaryFormatter((0, _last_value_utils.getLastValue)(metric === null || metric === void 0 ? void 0 : metric.data));
    const styles = {
      container: {},
      inner: {
        top: `${this.state.top || 0}px`,
        left: `${this.state.left || 0}px`,
        transform: `matrix(${scale}, 0, 0, ${scale}, ${translateX}, ${translateY})`
      },
      primary_value: {},
      secondary_value: {}
    };
    if (this.props.backgroundColor) styles.container.backgroundColor = this.props.backgroundColor;
    if (metric && metric.color) styles.primary_value.color = metric.color;
    let primaryLabel;
    if (metric && metric.label) {
      primaryLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__label--primary"
      }, metric.label);
    }
    let secondarySnippet;
    if (secondary) {
      const secondaryFormatter = secondary.formatter || (n => n);
      const secondaryValue = secondaryFormatter((0, _last_value_utils.getLastValue)(secondary.data));
      if (secondary.color) styles.secondary_value.color = secondary.color;
      let secondaryLabel;
      if (secondary.label) {
        secondaryLabel = /*#__PURE__*/_react.default.createElement("div", {
          className: "tvbVisMetric__label--secondary"
        }, secondary.label);
      }
      secondarySnippet = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__secondary"
      }, secondaryLabel, /*#__PURE__*/_react.default.createElement("div", {
        style: styles.secondary_value,
        className: "tvbVisMetric__value--secondary"
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: secondaryValue
        }
      })));
    }
    let additionalLabel;
    if (this.props.additionalLabel) {
      additionalLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__label--additional"
      }, this.props.additionalLabel);
    }
    let className = 'tvbVisMetric';
    if (!this.props.backgroundColor) {
      className += ' tvbVisMetric--noBackground';
    }
    if (this.props.reversed) {
      className += ' tvbVisMetric--reversed';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
      onResize: this.checkResizeThrottled
    }, resizeRef => /*#__PURE__*/_react.default.createElement(_render_counter.RenderCounter, {
      initialRender: initialRender,
      postponeExecution: !resized
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: className,
      ref: resizeRef,
      style: styles.container
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.resize = el,
      className: "tvbVisMetric__resize"
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.inner = el,
      className: "tvbVisMetric__inner",
      style: styles.inner
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbVisMetric__primary"
    }, primaryLabel, /*#__PURE__*/_react.default.createElement("div", {
      style: styles.primary_value,
      "data-test-subj": "tsvbMetricValue",
      className: "tvbVisMetric__value--primary"
    }, /*#__PURE__*/_react.default.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: primaryValue
      }
    }))), secondarySnippet, additionalLabel)))));
  }
}
exports.Metric = Metric;
Metric.propTypes = {
  backgroundColor: _propTypes.default.string,
  metric: _propTypes.default.object,
  secondary: _propTypes.default.object,
  reversed: _propTypes.default.bool,
  additionalLabel: _propTypes.default.string
};