"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _re_id_series = require("./lib/re_id_series");
var _series = require("./series");
var _collection_actions = require("./lib/collection_actions");
var _new_series_fn = require("./lib/new_series_fn");
var _eui = require("@elastic/eui");
var _reorder = require("./lib/reorder");
require("./_series_editor.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DROPPABLE_ID = 'series_editor_dnd';
class SeriesEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleClone", series => {
      const newSeries = (0, _re_id_series.reIdSeries)(series);
      _collection_actions.handleAdd.call(null, this.props, () => newSeries);
    });
    (0, _defineProperty2.default)(this, "sortHandler", ({
      destination,
      source
    }) => {
      const canSort = destination && source;
      if (canSort) {
        const sortFunction = this.getSortFunction({
          destination,
          source
        });
        sortFunction({
          destination,
          source
        });
      }
    });
    (0, _defineProperty2.default)(this, "getSortFunction", ({
      destination,
      source
    }) => destination.droppableId === source.droppableId && source.droppableId === DROPPABLE_ID ? this.sortSeries : this.sortAggregations);
    (0, _defineProperty2.default)(this, "sortSeries", ({
      destination,
      source
    }) => {
      this.props.onChange({
        series: (0, _reorder.reorder)([...this.props.model.series], source.index, destination.index)
      });
    });
    (0, _defineProperty2.default)(this, "sortAggregations", ({
      destination,
      source
    }) => {
      const extractId = ({
        droppableId
      }) => droppableId.split(':')[1];
      const id = extractId(source);
      const canSort = id === extractId(destination);
      if (canSort) {
        const model = [...this.props.model.series];
        const series = (0, _lodash.find)(model, {
          id
        });
        series.metrics = (0, _reorder.reorder)([...series.metrics], source.index, destination.index);
        this.props.onChange({
          series: model
        });
      }
    });
    (0, _defineProperty2.default)(this, "handleSeriesChange", doc => {
      (0, _collection_actions.handleChange)(this.props, doc);
    });
  }
  render() {
    const {
      limit,
      model,
      name,
      fields,
      colorPicker
    } = this.props;
    const list = model[name].filter((val, index) => index < (limit || Infinity));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: this.sortHandler
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: DROPPABLE_ID,
      spacing: "l",
      type: "MACRO"
    }, list.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "m",
      key: row.id,
      index: idx,
      customDragHandle: true,
      draggableId: `${DROPPABLE_ID}:${row.id}`,
      disableInteractiveElementBlocking: true
    }, provided => /*#__PURE__*/_react.default.createElement(_series.Series, {
      className: "tvbSeriesEditor",
      colorPicker: colorPicker,
      disableAdd: model[name].length >= limit,
      disableDelete: model[name].length < 2,
      fields: fields,
      onAdd: () => (0, _collection_actions.handleAdd)(this.props, _new_series_fn.newSeriesFn),
      onChange: this.handleSeriesChange,
      onClone: () => this.handleClone(row),
      onDelete: () => (0, _collection_actions.handleDelete)(this.props, row),
      model: row,
      panel: model,
      dragHandleProps: provided.dragHandleProps
    })))));
  }
}
exports.SeriesEditor = SeriesEditor;
SeriesEditor.defaultProps = {
  name: 'series',
  limit: Infinity,
  colorPicker: true
};
SeriesEditor.propTypes = {
  colorPicker: _propTypes.default.bool,
  fields: _propTypes.default.object,
  limit: _propTypes.default.number,
  model: _propTypes.default.object,
  name: _propTypes.default.string,
  onChange: _propTypes.default.func
};