"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderCounter = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** HOC component to call "initialRender" method after finishing all DOM mutations. **/
const RenderCounter = ({
  initialRender,
  children,
  postponeExecution = false
}) => {
  (0, _react.useLayoutEffect)(() => {
    if (!postponeExecution) {
      initialRender === null || initialRender === void 0 ? void 0 : initialRender();
    }
  }, [initialRender, postponeExecution]);
  return children !== null && children !== void 0 ? children : null;
};
exports.RenderCounter = RenderCounter;