"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIfSeriesHaveSameFormatters = void 0;
var _enums = require("../../../../common/enums");
var _agg_utils = require("../../../../common/agg_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const checkIfSeriesHaveSameFormatters = (seriesModel, fieldFormatMap) => {
  const uniqFormatters = new Set();
  seriesModel.forEach(seriesGroup => {
    if (!seriesGroup.separate_axis) {
      if (seriesGroup.formatter === _enums.DATA_FORMATTERS.DEFAULT) {
        const activeMetric = seriesGroup.metrics[seriesGroup.metrics.length - 1];
        const aggMeta = _agg_utils.aggs.find(agg => agg.id === activeMetric.type);
        if (activeMetric.field && aggMeta !== null && aggMeta !== void 0 && aggMeta.meta.isFieldRequired && fieldFormatMap !== null && fieldFormatMap !== void 0 && fieldFormatMap[activeMetric.field]) {
          return uniqFormatters.add(JSON.stringify(fieldFormatMap[activeMetric.field]));
        }
      }
      uniqFormatters.add(JSON.stringify({
        // requirement: in the case of using TSVB formatters, we do not need to check the value_template, just formatter!
        formatter: seriesGroup.formatter
      }));
    }
  });
  return uniqFormatters.size === 1;
};
exports.checkIfSeriesHaveSameFormatters = checkIfSeriesHaveSameFormatters;