"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopHitAgg = void 0;
var _react = _interopRequireWildcard(require("react"));
var _agg_row = require("./agg_row");
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _i18n = require("@kbn/i18n");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_number_handler = require("../lib/create_number_handler");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _enums = require("../../../../common/enums");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isFieldTypeEnabled = (fieldRestrictions, fieldType) => fieldRestrictions.length ? fieldRestrictions.includes(fieldType) : true;
const getAggWithOptions = (field = {}, fieldTypesRestriction) => {
  if (isFieldTypeEnabled(fieldTypesRestriction, field.type)) {
    switch (field.type) {
      case _public.KBN_FIELD_TYPES.NUMBER:
        return [{
          label: _i18n.i18n.translate('visTypeTimeseries.topHit.aggWithOptions.averageLabel', {
            defaultMessage: 'Avg'
          }),
          value: 'avg'
        }, {
          label: _i18n.i18n.translate('visTypeTimeseries.topHit.aggWithOptions.maxLabel', {
            defaultMessage: 'Max'
          }),
          value: 'max'
        }, {
          label: _i18n.i18n.translate('visTypeTimeseries.topHit.aggWithOptions.minLabel', {
            defaultMessage: 'Min'
          }),
          value: 'min'
        }, {
          label: _i18n.i18n.translate('visTypeTimeseries.topHit.aggWithOptions.sumLabel', {
            defaultMessage: 'Sum'
          }),
          value: 'sum'
        }];
      case _public.KBN_FIELD_TYPES.STRING:
      case _public.KBN_FIELD_TYPES.DATE:
        return [{
          label: _i18n.i18n.translate('visTypeTimeseries.topHit.aggWithOptions.concatenate', {
            defaultMessage: 'Concatenate'
          }),
          value: 'concat'
        }];
    }
  }
  return [];
};
const getOrderOptions = () => [{
  label: _i18n.i18n.translate('visTypeTimeseries.topHit.orderOptions.ascLabel', {
    defaultMessage: 'Asc'
  }),
  value: 'asc'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.topHit.orderOptions.descLabel', {
    defaultMessage: 'Desc'
  }),
  value: 'desc'
}];
const AGG_WITH_KEY = 'agg_with';
const ORDER_DATE_RESTRICT_FIELDS = [_public.KBN_FIELD_TYPES.DATE];
const getModelDefaults = () => ({
  order: 'desc',
  [AGG_WITH_KEY]: 'noop'
});
const TopHitAggUi = props => {
  var _fields$fieldsSelecto;
  const {
    fields,
    series,
    panel
  } = props;
  const model = (0, _react.useMemo)(() => ({
    ...getModelDefaults(),
    ...props.model
  }), [props.model]);
  const indexPattern = series.override_index_pattern ? series.series_index_pattern : panel.index_pattern;
  const aggWithOptionsRestrictFields = [_enums.PANEL_TYPES.TABLE, _enums.PANEL_TYPES.METRIC, _enums.PANEL_TYPES.MARKDOWN].includes(panel.type) ? [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.STRING, _public.KBN_FIELD_TYPES.DATE] : [_public.KBN_FIELD_TYPES.NUMBER];
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(handleChange);
  const fieldsSelector = (0, _index_patterns_utils.getIndexPatternKey)(indexPattern);
  const field = fields === null || fields === void 0 ? void 0 : (_fields$fieldsSelecto = fields[fieldsSelector]) === null || _fields$fieldsSelecto === void 0 ? void 0 : _fields$fieldsSelecto.find(f => f.name === model.field);
  const aggWithOptions = getAggWithOptions(field, aggWithOptionsRestrictFields);
  const orderOptions = getOrderOptions();
  const htmlId = (0, _eui.htmlIdGenerator)();
  const selectedAggWithOption = aggWithOptions.find(option => {
    return model[AGG_WITH_KEY] === option.value;
  });
  const selectedOrderOption = orderOptions.find(option => {
    return model.order === option.value;
  });
  (0, _react.useEffect)(() => {
    var _aggWithOptions$;
    const defaultFn = aggWithOptions === null || aggWithOptions === void 0 ? void 0 : (_aggWithOptions$ = aggWithOptions[0]) === null || _aggWithOptions$ === void 0 ? void 0 : _aggWithOptions$.value;
    const aggWith = model[AGG_WITH_KEY];
    if (aggWith && defaultFn && aggWith !== defaultFn && !selectedAggWithOption) {
      handleChange({
        [AGG_WITH_KEY]: defaultFn
      });
    }
  }, [model, selectedAggWithOption, aggWithOptions, handleChange]);
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.topHit.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topHit.fieldLabel",
      defaultMessage: "Field"
    }),
    fields: fields,
    type: model.type,
    restrict: aggWithOptionsRestrictFields,
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('size'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topHit.sizeLabel",
      defaultMessage: "Size"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    onChange: handleNumberChange('size', {
      isClearable: true
    }),
    value: model.size,
    placeholder: "1"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId(AGG_WITH_KEY),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topHit.aggregateWithLabel",
      defaultMessage: "Aggregate with"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    placeholder: _i18n.i18n.translate('visTypeTimeseries.topHit.aggregateWith.selectPlaceholder', {
      defaultMessage: 'Select...'
    }),
    options: aggWithOptions,
    selectedOptions: selectedAggWithOption ? [selectedAggWithOption] : [],
    onChange: handleSelectChange(AGG_WITH_KEY),
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "topHitAggregateWithComboBox"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topHit.orderByLabel",
      defaultMessage: "Order by"
    }),
    restrict: ORDER_DATE_RESTRICT_FIELDS,
    value: model.order_by,
    onChange: value => handleChange({
      order_by: value === null || value === void 0 ? void 0 : value[0]
    }),
    indexPattern: indexPattern,
    fields: fields,
    "data-test-subj": "topHitOrderByFieldSelect"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('order'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topHit.orderLabel",
      defaultMessage: "Order"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    placeholder: _i18n.i18n.translate('visTypeTimeseries.topHit.order.selectPlaceholder', {
      defaultMessage: 'Select...'
    }),
    options: orderOptions,
    selectedOptions: selectedOrderOption ? [selectedOrderOption] : [],
    onChange: handleSelectChange('order'),
    singleSelection: {
      asPlainText: true
    }
  })))));
};
const TopHitAgg = (0, _i18nReact.injectI18n)(TopHitAggUi);
exports.TopHitAgg = TopHitAgg;